//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.wizards;

import java.util.List;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;


/**
 * A wizrad that guides the user to open a Method Configuration.
 * 
 * @author Bingxue Xu
 * @since 1.0
 */
public class OpenConfigurationWizard extends Wizard implements INewWizard {

	protected OpenConfigurationMainPage mainPage;

	protected boolean okToComplete = false;

	protected List configurations = null;

	/**
	 * Creates a new instance.
	 */
	public OpenConfigurationWizard(List configurations) {
		super();
		this.configurations = configurations;
		setWindowTitle(AuthoringUIResources.AuthoringUIPlugin_OpenConfigurationWizard_windowTitle); //$NON-NLS-1$
	}

	/**
	 * Creates a new instance.
	 */
	public OpenConfigurationWizard() {
		this(null);
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench,
	 *      IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	public void addPages() {
		mainPage = new OpenConfigurationMainPage(
				OpenConfigurationMainPage.PAGE_NAME, null, null); //$NON-NLS-1$
		addPage(mainPage);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#canFinish()
	 */
	public boolean canFinish() {
		return okToComplete;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		return true;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performCancel()
	 */
	public boolean performCancel() {
		if (configurations != null)
			configurations.clear();
		return true;
	}

}
