//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.wizards;

import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;

public class SynchronizationChoices {

	public static int SYNC_NONE = 0;
	public static int SYNC_FROM_CONETNT = 1;
	public static int SYNC_FROM_PROCESS = 2;
	
	private Process selectedProcess;
	private MethodConfiguration selectedConfig;
	private int syncName= SYNC_FROM_CONETNT;
	private int syncPresName= SYNC_FROM_CONETNT;
	private int syncBriefDesc= SYNC_FROM_CONETNT;
	private int syncOptInput= SYNC_FROM_CONETNT;
	private int syncManInput= SYNC_FROM_CONETNT;
	private int syncOutput= SYNC_FROM_CONETNT;
	private int syncPrimPerformer= SYNC_FROM_CONETNT;
	private int syncAddnPerformer= SYNC_FROM_CONETNT;
	private int syncRespRole= SYNC_FROM_CONETNT;
	private int syncContArtifact= SYNC_FROM_CONETNT;
	private int syncDelivPart= SYNC_FROM_CONETNT;
	private int syncSelStep= SYNC_FROM_CONETNT;
	
	public boolean isFinishPressed;

	public Process getSelectedProcess() {
		return selectedProcess;
	}

	public void setSelectedProcess(Process selectedProcess) {
		this.selectedProcess = selectedProcess;
	}

	public MethodConfiguration getSelectedConfig() {
		return selectedConfig;
	}

	public void setSelectedConfig(MethodConfiguration selectedConfig) {
		this.selectedConfig = selectedConfig;
	}

	public int getSyncContArtifact() {
		return syncContArtifact;
	}

	public void setSyncContArtifact(int syncContArtifact) {
		this.syncContArtifact = syncContArtifact;
	}

	public int getSyncDelivPart() {
		return syncDelivPart;
	}

	public void setSyncDelivPart(int syncDelivPart) {
		this.syncDelivPart = syncDelivPart;
	}

	public int getSyncManInput() {
		return syncManInput;
	}

	public void setSyncManInput(int syncManInput) {
		this.syncManInput = syncManInput;
	}

	public int getSyncOptInput() {
		return syncOptInput;
	}

	public void setSyncOptInput(int syncOptInput) {
		this.syncOptInput = syncOptInput;
	}

	public int getSyncOutput() {
		return syncOutput;
	}

	public void setSyncOutput(int syncOutput) {
		this.syncOutput = syncOutput;
	}

	public int getSyncPresName() {
		return syncPresName;
	}

	public void setSyncPresName(int syncPresName) {
		this.syncPresName = syncPresName;
	}

	public int getSyncRespRole() {
		return syncRespRole;
	}

	public void setSyncRespRole(int syncRespRole) {
		this.syncRespRole = syncRespRole;
	}

	public int getSyncSelStep() {
		return syncSelStep;
	}

	public void setSyncSelStep(int syncSelStep) {
		this.syncSelStep = syncSelStep;
	}

	public boolean isFinishPressed() {
		return isFinishPressed;
	}

	public void setFinishPressed(boolean isFinishPressed) {
		this.isFinishPressed = isFinishPressed;
	}

	public int getSyncAddnPerformer() {
		return syncAddnPerformer;
	}

	public void setSyncAddnPerformer(int syncAddnPerformer) {
		this.syncAddnPerformer = syncAddnPerformer;
	}

	public int getSyncPrimPerformer() {
		return syncPrimPerformer;
	}

	public void setSyncPrimPerformer(int syncPrimPerformer) {
		this.syncPrimPerformer = syncPrimPerformer;
	}

	public String toString() {
		
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("[Process:" + ((selectedProcess != null)?selectedProcess.getName():"null") + ";"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		sbuf.append("Configuration:" + ((selectedConfig != null)?selectedConfig.getName():"null") + ";"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		sbuf.append("Name:" + syncName + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("PresName:" + syncPresName + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("BreifDesc:" + syncBriefDesc + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("OptInput:" + syncOptInput + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("ManInput:" + syncManInput + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("Output:" + syncOutput + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("PrimPerformer:" + syncPrimPerformer + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("AddnPerformers:" + syncAddnPerformer + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("RespRole:" + syncRespRole + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("ContArtifact:" + syncContArtifact + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("DelivPart:" + syncDelivPart + ";"); //$NON-NLS-1$ //$NON-NLS-2$
		sbuf.append("SelStep:" + syncSelStep + "]"); //$NON-NLS-1$ //$NON-NLS-2$

		return sbuf.toString();
	}

	public int getSyncBriefDesc() {
		return syncBriefDesc;
	}

	public void setSyncBriefDesc(int syncBriefDesc) {
		this.syncBriefDesc = syncBriefDesc;
	}

	public int getSyncName() {
		return syncName;
	}

	public void setSyncName(int syncName) {
		this.syncName = syncName;
	}
}
