//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.common.html;

import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

/**
 * Updates the HTML content in the current clipboard.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class HTMLClipboard {

	private static final String VERSION = "Version:"; //$NON-NLS-1$

	private static final String START_HTML = "StartHTML:"; //$NON-NLS-1$

	private static final String END_HTML = "StartHTML:"; //$NON-NLS-1$

	private static final String START_FRAGMENT = "StartFragment:"; //$NON-NLS-1$

	private static final String END_FRAGMENT = "EndFragment:"; //$NON-NLS-1$

	private static final String SOURCE_URL = "SourceURL:"; //$NON-NLS-1$

	private Clipboard clipboard;

	private TextTransfer textTransfer;

	private HTMLTransfer htmlTransfer;

	private String textContent;

	private String version;

	private String startHTML;

	private String endHTML;

	private String startFragment;

	private String endFragment;

	private String sourceURL;

	private String htmlSource;

	/**
	 * Creates a new instance.
	 */
	public HTMLClipboard() {
		this.clipboard = new Clipboard(Display.getCurrent());
		textTransfer = TextTransfer.getInstance();
		textContent = (String) clipboard.getContents(textTransfer);
		htmlTransfer = HTMLTransfer.getInstance();
		String htmlContent = (String) clipboard.getContents(htmlTransfer);
		if (htmlContent != null && htmlContent.length() > 0) {
			parseHTMLContent(htmlContent);
		}
	}

	/**
	 * Updates the clipboard content by replacing the source URL with a new
	 * value.
	 * 
	 * @param sourceURL
	 *            The new source URL.
	 */
	public void updateClipboard(String sourceURL) {
		int increment = sourceURL.length() - this.sourceURL.length() + 1;
		startHTML = updateValue(startHTML, increment);
		endHTML = updateValue(endHTML, increment);
		startFragment = updateValue(startFragment, increment);
		endFragment = updateValue(endFragment, increment);

		StringBuffer htmlContent = new StringBuffer(2048);
		htmlContent.append(VERSION).append(version).append(FileUtil.LINE_SEP);
		htmlContent.append(START_HTML).append(startHTML).append(
				FileUtil.LINE_SEP);
		htmlContent.append(END_HTML).append(endHTML).append(FileUtil.LINE_SEP);
		htmlContent.append(START_FRAGMENT).append(startFragment).append(
				FileUtil.LINE_SEP);
		htmlContent.append(END_FRAGMENT).append(endFragment).append(
				FileUtil.LINE_SEP);
		htmlContent.append(SOURCE_URL).append(sourceURL).append(
				FileUtil.LINE_SEP);
		htmlContent.append(htmlSource);

		clipboard.setContents(new Object[] { textContent,
				htmlContent.toString() }, new Transfer[] { textTransfer,
				htmlTransfer });
	}

	/**
	 * Disposes the clipboard.
	 */
	public void dispose() {
		clipboard.dispose();
	}

	/**
	 * Parses the HTML content in the given clipboard.
	 * 
	 * @param htmlContent
	 *            The HTML content in the clipboard.
	 */
	protected void parseHTMLContent(String htmlContent) {
		int index = htmlContent.indexOf(VERSION);
		if (index > 0) {
			version = htmlContent.substring(index + VERSION.length());
			version = version.substring(0, version.indexOf(FileUtil.LINE_SEP));
		}

		index = htmlContent.indexOf(START_HTML);
		if (index > 0) {
			startHTML = htmlContent.substring(index + START_HTML.length());
			startHTML = startHTML.substring(0, startHTML
					.indexOf(FileUtil.LINE_SEP));
		}

		index = htmlContent.indexOf(END_HTML);
		if (index > 0) {
			endHTML = htmlContent.substring(index + START_HTML.length());
			endHTML = endHTML.substring(0, endHTML.indexOf(FileUtil.LINE_SEP));
		}

		index = htmlContent.indexOf(START_FRAGMENT);
		if (index > 0) {
			startFragment = htmlContent.substring(index
					+ START_FRAGMENT.length());
			startFragment = startFragment.substring(0, startFragment
					.indexOf(FileUtil.LINE_SEP));
		}

		index = htmlContent.indexOf(END_FRAGMENT);
		if (index > 0) {
			endFragment = htmlContent.substring(index + END_FRAGMENT.length());
			endFragment = endFragment.substring(0, endFragment
					.indexOf(FileUtil.LINE_SEP));
		}

		index = htmlContent.indexOf(SOURCE_URL);
		if (index > 0) {
			sourceURL = htmlContent.substring(index + SOURCE_URL.length());
			sourceURL = sourceURL.substring(0, sourceURL
					.indexOf(FileUtil.LINE_SEP));
		}

		try {
			int startHTMLIndex = Integer.parseInt(startHTML);
			htmlSource = htmlContent.substring(startHTMLIndex);
		} catch (Exception e) {
		}
	}

	/**
	 * Updates the given string by adding the offset to its integer value.
	 * 
	 * @param value
	 *            A string representation of an integer.
	 * @param increment
	 *            The increment to add.
	 * @return An updated string.
	 */
	protected String updateValue(String value, int increment) {
		try {
			String newValue = "" + (Integer.parseInt(value) + increment); //$NON-NLS-1$
			String result = value.substring(0, value.length()
					- newValue.length())
					+ newValue;
			return result;
		} catch (Exception e) {
		}
		return value;
	}

}
