package org.eclipse.epf.common.serviceability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.osgi.framework.Version;

/**
 * This class stores all of the version info for the known EPF versions
 * @author jhardy
 *
 */
public class EPFVersions {
	
	public static final String TOOL_ID = "epf"; //$NON-NLS-1$

	
	// NOTE: XML import only checks the XML schema version.
	//       However, the XML import also depends on the 
	//		 library version being the same.
	//       Therefore, when library version changes,
	//       XML schema version MUST change also.
	
	// EPF 1.0
	private static EPFVersion EPF_10 = 
		new EPFVersion("1.0", //$NON-NLS-1$  tool version
				"1.0.3.0", //$NON-NLS-1$  library version
				"1.0.0"); //$NON-NLS-1$  xml schema version

	// EPF 1.1
//	private static EPFVersion EPF_11 = 
//	new EPFVersion("1.1", //$NON-NLS-1$  tool version
//			"1.0.3.1", //$NON-NLS-1$  library version
//			"1.0.1"); //$NON-NLS-1$  xml schema version
	
	private static EPFVersion currentVersion = EPF_10;
	
	public EPFVersion getCurrentVersion() {
		return currentVersion;
	}
	
	public EPFVersion getVersion(String toolVersion) {
		if (toolVersion != null) {
			for (Iterator iter = getAllVersions().iterator();iter.hasNext();) {
				EPFVersion ver = (EPFVersion)iter.next();
				if (ver.getToolVersion().equals(new Version(toolVersion))) {
					return ver;
				}
			}
		}
		return null;
	}
	
	public Collection getAllVersions() {
		List versions = new ArrayList();
		versions.add(EPF_10);
//		versions.add(EPF_11);
		return versions;
	}
	

	/**
	 * 
	 * @param libraryVersion
	 * @return the minimum tool version that uses the specified library version
	 */
	public EPFVersion getMinToolVersionForLibraryVersion(Version libraryVersion) {
		for (Iterator iter = getAllVersions().iterator();iter.hasNext();) {
			EPFVersion versionInfo = (EPFVersion)iter.next();
			if (versionInfo.getLibraryVersion().compareTo(libraryVersion) == 0) {
				return versionInfo;
			}
		}
		return null;
	}
	
	/**
	 * 
	 * @return the minimum tool version that uses the current library version
	 */
	public EPFVersion getMinToolVersionForCurrentLibraryVersion() {
		Version libraryVersion = getCurrentVersion().getLibraryVersion();
		return getMinToolVersionForLibraryVersion(libraryVersion);
	}

	/**
	 * 
	 * @param xmlSchemaVersion
	 * @return the minimum tool version that uses the specified XML Schema version
	 */
	public EPFVersion getMinToolVersionForXMLSchemaVersion(Version xmlSchemaVersion) {
		for (Iterator iter = getAllVersions().iterator();iter.hasNext();) {
			EPFVersion versionInfo = (EPFVersion)iter.next();
			if (versionInfo.getXMLSchemaVersion().compareTo(xmlSchemaVersion) == 0) {
				return versionInfo;
			}
		}
		return null;
	}
	
	/**
	 * 
	 * @return the minimum tool version that uses the current XML Schema version
	 */
	public EPFVersion getMinToolVersionForCurrentXMLSchemaVersion() {
		Version xmlSchemaVersion = getCurrentVersion().getXMLSchemaVersion();
		return getMinToolVersionForXMLSchemaVersion(xmlSchemaVersion);
	}

}
