package org.eclipse.epf.common.serviceability;

import org.osgi.framework.Version;

public class VersionMismatchException extends RuntimeException {

	private static final long serialVersionUID = 1L;
	
	private Version expected;
	private Version actual;

    public VersionMismatchException(Version expected, String actual) {
    	super();
    	this.expected = expected;
    	if (actual == null) {
    		this.actual = Version.emptyVersion;
    	} else {
    		this.actual = new Version(actual);
    	}
    }

	public Version getActual() {
		return actual;
	}

	public Version getExpected() {
		return expected;
	}
}
