//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.diagram.model;

import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.Suppression;


/**
 * @author Phong Nguyen Le
 * @since 1.0
 * @model
 */
public interface Diagram extends NodeContainer {
    
    org.eclipse.epf.uma.Diagram getUMADiagram();
	
	/**
	 * Sets default name for new node
	 * @param newNode
	 */
	void setDefaultName(NamedNode newNode);
	
	void setSuppression(Suppression suppression);
	
	Suppression getSuppression();
	
	void setFilter(IFilter filter);	
	
	boolean isNew();
	void setNew(boolean n);
}