//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.diagram.model;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;

/**
 * @author Phong Nguyen Le
 * @since 1.0
 * @model
 */
public interface Link
	extends LinkedObject{
	/**
	 * @model
	 */
	Node getSource();

	/**
	 * Sets the value of the '{@link org.eclipse.epf.diagram.model.Link#getSource <em>Source</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source</em>' container reference.
	 * @see #getSource()
	 * @generated
	 */
	void setSource(Node value);

	/**
	 * @model
	 */
	Node getTarget();

	/**
	 * Sets the value of the '{@link org.eclipse.epf.diagram.model.Link#getTarget <em>Target</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target</em>' reference.
	 * @see #getTarget()
	 * @generated
	 */
	void setTarget(Node value);

	/**
	 * @model type="org.eclipse.draw2d.AbsoluteBendpoint" lower="0"
	 */
	EList getBendpoints();

	/**
	 * @model
	 * @return
	 */
	Point getSourceEndPoint();
	
	/**
	 * Sets the value of the '{@link org.eclipse.epf.diagram.model.Link#getSourceEndPoint <em>Source End Point</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source End Point</em>' attribute.
	 * @see #getSourceEndPoint()
	 * @generated
	 */
	void setSourceEndPoint(Point value);

	/**
	 * @model
	 * @return
	 */
	Point getTargetEndPoint();
	/**
	 * Sets the value of the '{@link org.eclipse.epf.diagram.model.Link#getTargetEndPoint <em>Target End Point</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target End Point</em>' attribute.
	 * @see #getTargetEndPoint()
	 * @generated
	 */
	void setTargetEndPoint(Point value);

}