//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.diagram.model;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.uma.GraphNode;


/**
 * @author Phong Nguyen Le
 * @since 1.0
 * @model abstract="true"
 */
public interface Node
	extends LinkedObject{

	/**
	 * @model
	 */
	Point getLocation();
	
	/**
	 * @model default="-1"
	 */
	int getWidth();
	
	/**
	 * 
	 * @return
	 * @model default="-1"
	 */
	int getHeight();

	/**
	 * Sets the value of the '{@link org.eclipse.epf.diagram.model.Node#getHeight <em>Height</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Height</em>' attribute.
	 * @see #getHeight()
	 * @generated
	 */
    void setHeight(int value);

	/**
	 * Sets the value of the '{@link org.eclipse.epf.diagram.model.Node#getWidth <em>Width</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Width</em>' attribute.
	 * @see #getWidth()
	 * @generated
	 */
	void setWidth(int value);

	/**
	 * Sets the value of the '{@link org.eclipse.epf.diagram.model.Node#getLocation <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Location</em>' attribute.
	 * @see #getLocation()
	 * @generated
	 */
	void setLocation(Point value);

	/**
	 * @model type="Link" opposite="target" lower="0"
	 */
	EList getIncomingConnections(); 
	
	/**
	 * @model type="Link" containment="true" opposite="source" lower="0"
	 */
	EList getOutgoingConnections();
	
	/**
	 * @model
	 */
	boolean isReadOnly();
	
	/**
	 * Sets the value of the '{@link org.eclipse.epf.diagram.model.Node#isReadOnly <em>Read Only</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Read Only</em>' attribute.
	 * @see #isReadOnly()
	 * @generated
	 */
	void setReadOnly(boolean value);

	Diagram getDiagram();
	
	void setDiagram(Diagram diagram);

	/**
	 * Gets the GraphNode associated with this node.
	 * 
	 * @return
	 */
    GraphNode getGraphNode();
    
	Class getMethodElementAdapterType();

	/**
	 * This method is used to set the UMA diagram for the new node so it can find
	 * the GraphNode for the linked method element.
	 * 
	 * @param umaDiagram
	 */
    void setUMADiagram(org.eclipse.epf.uma.Diagram umaDiagram);

	void setUMAContainer(GraphNode umaContainer);
	
	/**
	 * Adds the given consumer to the consumer list of this node.
	 * 
	 * @param consumer
	 */
	void addConsumer(Object consumer);
	
	/**
	 * Removes the given consumer from the consumer list of this node.
	 * Disposes the node if it does not have any more consumer after this call.
	 * Disposing a node will take care of removing this node's listener from the UMA object
	 * and all the adapters that had been added to the adapter list of this node.
	 * 
	 * @param consumer
	 */
	void removeConsumer(Object consumer);
	
}