//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.diagram.model.impl;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;


/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Task Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 * 
 * @generated
 */
public class TaskNodeImpl extends NamedNodeImpl implements TaskNode {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 */
	protected TaskNodeImpl() {
		super();

		methodElementAdapter = new TaskDescriptorAdapter();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ModelPackage.eINSTANCE.getTaskNode();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
			case ModelPackage.TASK_NODE__INCOMING_CONNECTIONS:
				return ((InternalEList) getIncomingConnections()).basicAdd(
						otherEnd, msgs);
			case ModelPackage.TASK_NODE__OUTGOING_CONNECTIONS:
				return ((InternalEList) getOutgoingConnections()).basicAdd(
						otherEnd, msgs);
			default:
				return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
			case ModelPackage.TASK_NODE__INCOMING_CONNECTIONS:
				return ((InternalEList) getIncomingConnections()).basicRemove(
						otherEnd, msgs);
			case ModelPackage.TASK_NODE__OUTGOING_CONNECTIONS:
				return ((InternalEList) getOutgoingConnections()).basicRemove(
						otherEnd, msgs);
			default:
				return eDynamicInverseRemove(otherEnd, featureID, baseClass,
						msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
		case ModelPackage.TASK_NODE__OBJECT:
			return getObject();
		case ModelPackage.TASK_NODE__LOCATION:
			return getLocation();
		case ModelPackage.TASK_NODE__WIDTH:
			return new Integer(getWidth());
		case ModelPackage.TASK_NODE__HEIGHT:
			return new Integer(getHeight());
		case ModelPackage.TASK_NODE__INCOMING_CONNECTIONS:
			return getIncomingConnections();
		case ModelPackage.TASK_NODE__OUTGOING_CONNECTIONS:
			return getOutgoingConnections();
		case ModelPackage.TASK_NODE__READ_ONLY:
			return isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
		case ModelPackage.TASK_NODE__NAME:
			return getName();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
		case ModelPackage.TASK_NODE__OBJECT:
			setObject((Object) newValue);
			return;
		case ModelPackage.TASK_NODE__LOCATION:
			setLocation((Point) newValue);
			return;
		case ModelPackage.TASK_NODE__WIDTH:
			setWidth(((Integer) newValue).intValue());
			return;
		case ModelPackage.TASK_NODE__HEIGHT:
			setHeight(((Integer) newValue).intValue());
			return;
		case ModelPackage.TASK_NODE__INCOMING_CONNECTIONS:
			getIncomingConnections().clear();
			getIncomingConnections().addAll((Collection) newValue);
			return;
		case ModelPackage.TASK_NODE__OUTGOING_CONNECTIONS:
			getOutgoingConnections().clear();
			getOutgoingConnections().addAll((Collection) newValue);
			return;
		case ModelPackage.TASK_NODE__READ_ONLY:
			setReadOnly(((Boolean) newValue).booleanValue());
			return;
		case ModelPackage.TASK_NODE__NAME:
			setName((String) newValue);
			return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
		case ModelPackage.TASK_NODE__OBJECT:
			setObject(OBJECT_EDEFAULT);
			return;
		case ModelPackage.TASK_NODE__LOCATION:
			setLocation(LOCATION_EDEFAULT);
			return;
		case ModelPackage.TASK_NODE__WIDTH:
			setWidth(WIDTH_EDEFAULT);
			return;
		case ModelPackage.TASK_NODE__HEIGHT:
			setHeight(HEIGHT_EDEFAULT);
			return;
		case ModelPackage.TASK_NODE__INCOMING_CONNECTIONS:
			getIncomingConnections().clear();
			return;
		case ModelPackage.TASK_NODE__OUTGOING_CONNECTIONS:
			getOutgoingConnections().clear();
			return;
		case ModelPackage.TASK_NODE__READ_ONLY:
			setReadOnly(READ_ONLY_EDEFAULT);
			return;
		case ModelPackage.TASK_NODE__NAME:
			setName(NAME_EDEFAULT);
			return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
		case ModelPackage.TASK_NODE__OBJECT:
			return OBJECT_EDEFAULT == null ? object != null : !OBJECT_EDEFAULT
					.equals(object);
		case ModelPackage.TASK_NODE__LOCATION:
			return LOCATION_EDEFAULT == null ? location != null
					: !LOCATION_EDEFAULT.equals(location);
		case ModelPackage.TASK_NODE__WIDTH:
			return width != WIDTH_EDEFAULT;
		case ModelPackage.TASK_NODE__HEIGHT:
			return height != HEIGHT_EDEFAULT;
		case ModelPackage.TASK_NODE__INCOMING_CONNECTIONS:
			return incomingConnections != null
					&& !incomingConnections.isEmpty();
		case ModelPackage.TASK_NODE__OUTGOING_CONNECTIONS:
			return outgoingConnections != null
					&& !outgoingConnections.isEmpty();
		case ModelPackage.TASK_NODE__READ_ONLY:
			return readOnly != READ_ONLY_EDEFAULT;
		case ModelPackage.TASK_NODE__NAME:
			return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
					.equals(name);
		}
		return eDynamicIsSet(eFeature);
	}

	private class TaskDescriptorAdapter extends MethodElementAdapter {
		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.impl.AdapterImpl#notifyChanged(org.eclipse.emf.common.notify.Notification)
		 */
		public void notifyChanged(Notification msg) {
			if (!notificationEnabled)
				return;
			notificationEnabled = false;
			try {
				MethodElement obj;
				switch (msg.getFeatureID(TaskDescriptor.class)) {
				case UmaPackage.TASK_DESCRIPTOR__MANDATORY_INPUT:
				case UmaPackage.TASK_DESCRIPTOR__OPTIONAL_INPUT:
				case UmaPackage.TASK_DESCRIPTOR__EXTERNAL_INPUT:
					switch (msg.getEventType()) {
					case Notification.ADD:
						obj = (MethodElement) msg.getNewValue();
						addIncomingConnection(obj);
						return;
					case Notification.REMOVE:
						obj = (MethodElement) msg.getOldValue();
						removeIncomingConnection(obj);
						return;
					case Notification.ADD_MANY:
						Collection collection = (Collection) msg.getNewValue();
						for (Iterator iter = collection.iterator(); iter
								.hasNext();) {
							obj = (MethodElement) iter.next();
							addIncomingConnection(obj);
						}
						return;
					case Notification.REMOVE_MANY:
						collection = (Collection) msg.getOldValue();
						for (Iterator iter = collection.iterator(); iter
								.hasNext();) {
							obj = (MethodElement) iter.next();
							removeIncomingConnection(obj);
						}
						return;
					}
					break;
				case UmaPackage.TASK_DESCRIPTOR__OUTPUT:
					switch (msg.getEventType()) {
					case Notification.ADD:
						obj = (MethodElement) msg.getNewValue();
						addOutgoingConnection(obj);
						return;
					case Notification.REMOVE:
						obj = (MethodElement) msg.getOldValue();
						removeOutgoingConnection(obj);
						return;
					case Notification.ADD_MANY:
						Collection collection = (Collection) msg.getNewValue();
						for (Iterator iter = collection.iterator(); iter
								.hasNext();) {
							obj = (MethodElement) iter.next();
							addOutgoingConnection(obj);
						}
						return;
					case Notification.REMOVE_MANY:
						collection = (Collection) msg.getOldValue();
						for (Iterator iter = collection.iterator(); iter
								.hasNext();) {
							obj = (MethodElement) iter.next();
							removeOutgoingConnection(obj);
						}
						return;
					}
					break;
				}
			} finally {
				notificationEnabled = true;
			}

			super.notifyChanged(msg);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.epf.diagram.model.util.INodeChangeListener#getNode()
		 */
		public Node getNode() {
			return TaskNodeImpl.this;
		}
	}

	// /* (non-Javadoc)
	// * @see
	// org.eclipse.epf.diagram.model.impl.NamedNodeImpl#setObject(java.lang.Object)
	// */
	// public void setObject(Object newObject) {
	// Object oldObject = object;
	// object = newObject;
	// if (eNotificationRequired())
	// eNotify(new ENotificationImpl(this, Notification.SET,
	// ModelPackage.LINKED_OBJECT__OBJECT, oldObject, object));
	//
	// if(newObject == null) return;
	//		
	// MethodElement element = (MethodElement) newObject;
	// if(element != null && getMethodElementAdapterType() != null) {
	// // remove old methodElementAdapter
	// //
	// Object oldAdapter = UmaUtil.getAdapter(element,
	// getMethodElementAdapterType());
	// if(oldAdapter != null) {
	// element.eAdapters().remove(oldAdapter);
	// }
	// }
	// graphNode =
	// GraphicalDataManager.getInstance().getGraphNode(getUMADiagram(),
	// element);
	//        
	// // System.out.println("NodeImpl.setObject(): element: '" +
	// element.getName() + "', graphNode: " + graphNode);
	//        
	// // populate data
	// //
	// setHeight(graphNode.getSize().getHeight().intValue());
	// setLocation(GraphicalDataHelper.toPoint(graphNode.getPosition()));
	// setWidth(graphNode.getSize().getWidth().intValue());
	//        
	// // add methodElementAdapter
	// //
	// if(methodElementAdapter != null) {
	// element.eAdapters().add(methodElementAdapter);
	// }
	//        
	// this.eAdapters().add(createNodeAdapter());
	//
	// setName(element.getName());
	// }

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.epf.diagram.model.impl.NodeImpl#addToUMA(org.eclipse.epf.diagram.model.Link)
	 */
	protected boolean addToUMA(Link link) {
		if (!super.addToUMA(link))
			return false;

		//TaskDescriptor taskDesc = (TaskDescriptor) getObject();
		NodeImpl nodeImpl = (NodeImpl) link.getSource();
		boolean notify = notificationEnabled;
		boolean notifySource = nodeImpl.notificationEnabled;
		try {
			notificationEnabled = false;
			nodeImpl.notificationEnabled = false;
			// taskDesc.getMandatoryInput().add(link.getSource().getObject());
		} finally {
			notificationEnabled = notify;
			nodeImpl.notificationEnabled = notifySource;
		}

		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.epf.diagram.model.impl.NodeImpl#removeFromUMA(org.eclipse.epf.diagram.model.Link,
	 *      org.eclipse.epf.diagram.model.Node, org.eclipse.epf.diagram.model.Node)
	 */
	protected void removeFromUMA(Link link, Node oldSource, Node oldTarget) {
		TaskDescriptor taskDesc = (TaskDescriptor) getObject();
		taskDesc.getOutput().remove(link.getTarget().getObject());

		super.removeFromUMA(link, oldSource, oldTarget);
	}

} // TaskNodeImpl
