//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.diagram.model.impl;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.WorkProductNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;


/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Work Product Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.epf.diagram.model.impl.WorkProductNodeImpl#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class WorkProductNodeImpl extends NamedNodeImpl implements
		WorkProductNode {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final int TYPE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected int type = TYPE_EDEFAULT;

	private class WorkProductDescriptorAdapter extends MethodElementAdapter {

		public Node getNode() {
			return WorkProductNodeImpl.this;
		}

		public void notifyChanged(Notification msg) {
			if (!notificationEnabled)
				return;
			notificationEnabled = false;

			try {
				switch (msg.getFeatureID(WorkProductDescriptor.class)) {
				case UmaPackage.WORK_PRODUCT_DESCRIPTOR__IMPACTED_BY:
					MethodElement obj;
					switch (msg.getEventType()) {
					case Notification.ADD:
						obj = (MethodElement) msg.getNewValue();
						addIncomingConnection(obj);
						return;
					case Notification.REMOVE:
						obj = (MethodElement) msg.getOldValue();
						removeIncomingConnection(obj);
						return;
					case Notification.ADD_MANY:
						Collection collection = (Collection) msg.getNewValue();
						for (Iterator iter = collection.iterator(); iter
								.hasNext();) {
							obj = (MethodElement) iter.next();
							addIncomingConnection(obj);
						}
						return;
					case Notification.REMOVE_MANY:
						collection = (Collection) msg.getOldValue();
						for (Iterator iter = collection.iterator(); iter
								.hasNext();) {
							obj = (MethodElement) iter.next();
							removeIncomingConnection(obj);
						}
						return;
					}

				}
				super.notifyChanged(msg);
			} finally {
				notificationEnabled = true;
			}
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 */
	protected WorkProductNodeImpl() {
		super();

		methodElementAdapter = new WorkProductDescriptorAdapter();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ModelPackage.eINSTANCE.getWorkProductNode();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public int getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setType(int newType) {
		int oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.WORK_PRODUCT_NODE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
			case ModelPackage.WORK_PRODUCT_NODE__INCOMING_CONNECTIONS:
				return ((InternalEList) getIncomingConnections()).basicAdd(
						otherEnd, msgs);
			case ModelPackage.WORK_PRODUCT_NODE__OUTGOING_CONNECTIONS:
				return ((InternalEList) getOutgoingConnections()).basicAdd(
						otherEnd, msgs);
			default:
				return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
			case ModelPackage.WORK_PRODUCT_NODE__INCOMING_CONNECTIONS:
				return ((InternalEList) getIncomingConnections()).basicRemove(
						otherEnd, msgs);
			case ModelPackage.WORK_PRODUCT_NODE__OUTGOING_CONNECTIONS:
				return ((InternalEList) getOutgoingConnections()).basicRemove(
						otherEnd, msgs);
			default:
				return eDynamicInverseRemove(otherEnd, featureID, baseClass,
						msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
		case ModelPackage.WORK_PRODUCT_NODE__OBJECT:
			return getObject();
		case ModelPackage.WORK_PRODUCT_NODE__LOCATION:
			return getLocation();
		case ModelPackage.WORK_PRODUCT_NODE__WIDTH:
			return new Integer(getWidth());
		case ModelPackage.WORK_PRODUCT_NODE__HEIGHT:
			return new Integer(getHeight());
		case ModelPackage.WORK_PRODUCT_NODE__INCOMING_CONNECTIONS:
			return getIncomingConnections();
		case ModelPackage.WORK_PRODUCT_NODE__OUTGOING_CONNECTIONS:
			return getOutgoingConnections();
		case ModelPackage.WORK_PRODUCT_NODE__READ_ONLY:
			return isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
		case ModelPackage.WORK_PRODUCT_NODE__NAME:
			return getName();
		case ModelPackage.WORK_PRODUCT_NODE__TYPE:
			return new Integer(getType());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
		case ModelPackage.WORK_PRODUCT_NODE__OBJECT:
			setObject((Object) newValue);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__LOCATION:
			setLocation((Point) newValue);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__WIDTH:
			setWidth(((Integer) newValue).intValue());
			return;
		case ModelPackage.WORK_PRODUCT_NODE__HEIGHT:
			setHeight(((Integer) newValue).intValue());
			return;
		case ModelPackage.WORK_PRODUCT_NODE__INCOMING_CONNECTIONS:
			getIncomingConnections().clear();
			getIncomingConnections().addAll((Collection) newValue);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__OUTGOING_CONNECTIONS:
			getOutgoingConnections().clear();
			getOutgoingConnections().addAll((Collection) newValue);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__READ_ONLY:
			setReadOnly(((Boolean) newValue).booleanValue());
			return;
		case ModelPackage.WORK_PRODUCT_NODE__NAME:
			setName((String) newValue);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__TYPE:
			setType(((Integer) newValue).intValue());
			return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
		case ModelPackage.WORK_PRODUCT_NODE__OBJECT:
			setObject(OBJECT_EDEFAULT);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__LOCATION:
			setLocation(LOCATION_EDEFAULT);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__WIDTH:
			setWidth(WIDTH_EDEFAULT);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__HEIGHT:
			setHeight(HEIGHT_EDEFAULT);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__INCOMING_CONNECTIONS:
			getIncomingConnections().clear();
			return;
		case ModelPackage.WORK_PRODUCT_NODE__OUTGOING_CONNECTIONS:
			getOutgoingConnections().clear();
			return;
		case ModelPackage.WORK_PRODUCT_NODE__READ_ONLY:
			setReadOnly(READ_ONLY_EDEFAULT);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__NAME:
			setName(NAME_EDEFAULT);
			return;
		case ModelPackage.WORK_PRODUCT_NODE__TYPE:
			setType(TYPE_EDEFAULT);
			return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
		case ModelPackage.WORK_PRODUCT_NODE__OBJECT:
			return OBJECT_EDEFAULT == null ? object != null : !OBJECT_EDEFAULT
					.equals(object);
		case ModelPackage.WORK_PRODUCT_NODE__LOCATION:
			return LOCATION_EDEFAULT == null ? location != null
					: !LOCATION_EDEFAULT.equals(location);
		case ModelPackage.WORK_PRODUCT_NODE__WIDTH:
			return width != WIDTH_EDEFAULT;
		case ModelPackage.WORK_PRODUCT_NODE__HEIGHT:
			return height != HEIGHT_EDEFAULT;
		case ModelPackage.WORK_PRODUCT_NODE__INCOMING_CONNECTIONS:
			return incomingConnections != null
					&& !incomingConnections.isEmpty();
		case ModelPackage.WORK_PRODUCT_NODE__OUTGOING_CONNECTIONS:
			return outgoingConnections != null
					&& !outgoingConnections.isEmpty();
		case ModelPackage.WORK_PRODUCT_NODE__READ_ONLY:
			return readOnly != READ_ONLY_EDEFAULT;
		case ModelPackage.WORK_PRODUCT_NODE__NAME:
			return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
					.equals(name);
		case ModelPackage.WORK_PRODUCT_NODE__TYPE:
			return type != TYPE_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: "); //$NON-NLS-1$
		result.append(type);
		result.append(')');
		return result.toString();
	}

	protected boolean addToUMA(Link link) {
		if (!super.addToUMA(link))
			return false;

		WorkProductDescriptor descriptor = (WorkProductDescriptor) link
				.getSource().getObject();

		NodeImpl source = (NodeImpl) link.getSource();
		NodeImpl target = (NodeImpl) link.getTarget();
		boolean notifySource = source.notificationEnabled;
		boolean notifyTarget = target.notificationEnabled;
		try {
			source.notificationEnabled = target.notificationEnabled = false;
			descriptor.getImpacts().add(link.getTarget().getObject());
		} finally {
			source.notificationEnabled = notifySource;
			target.notificationEnabled = notifyTarget;
		}

		return true;
	}

	protected void removeFromUMA(Link link, Node oldSource, Node oldTarget) {
		WorkProductDescriptor descriptor = (WorkProductDescriptor) oldTarget
				.getObject();
		// disable internal notification of the target node before removing its
		// descriptor from the dependency list
		//
		NamedNodeImpl nodeImpl = (NamedNodeImpl) oldSource;
		boolean notify = nodeImpl.notificationEnabled;
		try {
			nodeImpl.notificationEnabled = false;
			descriptor.getImpactedBy().remove(nodeImpl.getObject());
		} finally {
			nodeImpl.notificationEnabled = notify;
		}

		super.removeFromUMA(link, oldSource, oldTarget);
	}

} // WorkProductNodeImpl
