//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp;

import org.eclipse.osgi.util.NLS;

/**
 * The Export Microsoft Project message resource bundle accessor class.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public final class ExportMSPResources extends NLS {

	private static String BUNDLE_NAME = ExportMSPResources.class.getPackage()
			.getName()
			+ ".Resources"; //$NON-NLS-1$

	private ExportMSPResources() {
		// Do not instantiate
	}

	public static String exportMSPWizard_title;

	public static String selectProcessWizardPage_title;

	public static String selectProcessWizardPage_text;

	public static String processGroup_text;

	public static String capabilityPatternRadioButton_text;

	public static String deliveryProcessRadioButton_text;

	public static String processNameLabel_text;

	public static String contextNameLabel_text;

	public static String optionsGroup_text;

	public static String publishConfigurationCheckBox_text;

	public static String exportOnlyPlannedElementsCheckBox_text;

	public static String selectPublishOptionsWizardPage_title;

	public static String selectPublishOptionsWizardPage_text;

	public static String selectExportDirWizardPage_title;

	public static String selectExportDirWizardPage_text;

	public static String projectNameLabel_text;

	public static String dirLabel_text;

	public static String browseButton_text;

	public static String exportMSPTask_name;

	public static String overwriteText_msg;

	public static String completedText_msg;

	public static String exportMSPError_msg;

	public static String exportMSPError_reason;

	static {
		NLS.initializeMessages(BUNDLE_NAME, ExportMSPResources.class);
	}
}