//------------------------------------------------------------------------------
// Copyright (c) 2004, 2005 IBM Corporation.  All Rights Reserved.
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;

/**
 * Helper utilities for the Export Microsoft Project Service implementation.
 *
 * @author Kelvin Low
 * @since  1.0
 */
public class ExportMSPUtil {

	/**
	 * Returns a map of all the <code>CapabilityPattern</code> and <code>DeliveryProcess</code>
	 * in the current Method Library.
	 *
	 * TODO: Move this method to the com.ibm.rmm.library.services.LibraryUtil class.
	 */
	public static Map getProcesses() {
		MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
		if (library == null) {
			return null;
		}

		Map result = new TreeMap();
		List methodPlugins = LibraryUtil.getMethodPlugins(library);
		for (Iterator i = methodPlugins.iterator(); i.hasNext(); ) {
			MethodPlugin methodPlugin = (MethodPlugin)i.next();
			String capabilityPatternPaths[] = ModelStructure.DEFAULT.capabilityPatternPath;
			MethodPackage methodPackage  = UmaUtil.findMethodPackage(methodPlugin, capabilityPatternPaths);
			if (methodPackage instanceof ProcessPackage) {
				if (methodPackage instanceof ProcessPackage) {
					getCapabilityPatterns((ProcessPackage)methodPackage, result);
				}
			}
			String deliveryProcessPaths[] = ModelStructure.DEFAULT.deliveryProcessPath;
			methodPackage = UmaUtil.findMethodPackage(methodPlugin, deliveryProcessPaths);
			if (methodPackage instanceof ProcessPackage) {
				if (methodPackage instanceof ProcessPackage) {
					getDeliveryProcesses((ProcessPackage)methodPackage, result);
				}
			}
		}
		return result;
	}

	/**
	 * Returns a map of all <code>CapabilityPattern</code> in the current Method Library.
	 *
	 * TODO: Move this method to the com.ibm.rmm.library.services.LibraryUtil class.
	 */
	public static Map getCapabilityPatterns() {
		MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
		if (library == null) {
			return null;
		}

		Map result = new TreeMap();
		List methodPlugins = LibraryUtil.getMethodPlugins(library);
		for (Iterator i = methodPlugins.iterator(); i.hasNext(); ) {
			MethodPlugin methodPlugin = (MethodPlugin)i.next();
			String capabilityPatternPaths[] = ModelStructure.DEFAULT.capabilityPatternPath;
			MethodPackage methodPackage  = UmaUtil.findMethodPackage(methodPlugin, capabilityPatternPaths);
			if (methodPackage instanceof ProcessPackage) {
				getCapabilityPatterns((ProcessPackage)methodPackage, result);
			}
		}
		return result;
	}

	/**
	 * Returns a map of all the <code>DeliveryProcess</code> in the current Method Library.
	 *
	 * TODO: Move this method to the com.ibm.rmm.library.services.LibraryUtil class.
	 */
	public static Map getDeliveryProcesses() {
		MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
		if (library == null) {
			return null;
		}

		Map result = new TreeMap();
		List methodPlugins = LibraryUtil.getMethodPlugins(library);
		for (Iterator i = methodPlugins.iterator(); i.hasNext(); ) {
			MethodPlugin methodPlugin = (MethodPlugin)i.next();
			String deliveryProcessPaths[] = ModelStructure.DEFAULT.deliveryProcessPath;
			MethodPackage methodPackage = UmaUtil.findMethodPackage(methodPlugin, deliveryProcessPaths);
			if (methodPackage instanceof ProcessPackage) {
				getDeliveryProcesses((ProcessPackage)methodPackage, result);
			}
		}
		return result;
	}

	/**
	 * Returns a map of all the contexts associated with a process.
	 *
	 * TODO: Move this method to the com.ibm.rmm.library.services.LibraryUtil class.
	 */
	public static Map getContexts(Process process) {
		if (process == null) {
			return null;
		}

		MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
		if (library == null) {
			return null;
		}

		Map result = new TreeMap();
		MethodConfiguration defaultContext = process.getDefaultContext();
		if (defaultContext != null) {
			result.put(defaultContext.getName(), defaultContext);
		}

		List contexts = process.getValidContext();
		for (Iterator i = contexts.iterator(); i.hasNext(); ) {
			MethodConfiguration context = (MethodConfiguration)i.next();
			if (context != null) {
				result.put(context.getName(), context);
			}
		}

		return result;
	}

	/**
	 * Add a map of all <code>CapabilityPattern</code> in a given <code>ProcessPackage</code>.
	 *
	 * TODO: Move this method to the com.ibm.rmm.library.services.LibraryUtil class.
	 */
	protected static void getCapabilityPatterns(ProcessPackage processPackage, Map result) {
		List childPackages = processPackage.getChildPackages();
		for (Iterator i = childPackages.iterator(); i.hasNext(); ) {
			Object obj = i.next();
			if (obj instanceof ProcessComponent) {
				ProcessComponent processComponent = (ProcessComponent)obj;
				org.eclipse.epf.uma.Process process  = processComponent.getProcess();
				if (process instanceof CapabilityPattern) {
					String name = process.getName();
					result.put(name, process);
				}
			}
			else if (obj instanceof ProcessPackage) {
				getCapabilityPatterns((ProcessPackage)obj, result);
			}
		}
	}

	/**
	 * Add a map of all <code>DeliveryProcess</code> in a given <code>ProcessPackage</code>.
	 *
	 * TODO: Move this method to the com.ibm.rmm.library.services.LibraryUtil class.
	 */
	protected static void getDeliveryProcesses(ProcessPackage processPackage, Map result) {
		List childPackages = processPackage.getChildPackages();
		for (Iterator i = childPackages.iterator(); i.hasNext(); ) {
			Object obj = i.next();
			if (obj instanceof ProcessComponent) {
				ProcessComponent processComponent = (ProcessComponent)obj;
				org.eclipse.epf.uma.Process process  = processComponent.getProcess();
				if (process instanceof DeliveryProcess) {
					String name = process.getName();
					result.put(name, process);
				}
			}
			else if (obj instanceof ProcessPackage) {
				getDeliveryProcesses((ProcessPackage)obj, result);
			}
		}
	}

}
