//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp;

import java.io.File;

import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.uma.Process;

/**
 * The interface for the Export Microsoft Project Service.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public interface IExportMSPService {

	/**
	 * Export a process to a Microsoft Project XML file.
	 * 
	 * @param process
	 *            a capability pattern or delivery process
	 * @param name
	 *            the name of the exported Microsoft Project Plan
	 * @param targetDir
	 *            the target directory
	 * @param exportOptions
	 *            a collection of user specified export options
	 * @param publishConfigOptions
	 *            a collection of user specified publishing options for the
	 *            selected configuration
	 * @return <code>true</code> if the operation was completed successfully
	 * @throws ExportMSPServiceException
	 *             if an error occurs while executing the operation
	 */
	public boolean exportMSPXML(Process process, String templateName,
			File targetDir, ExportOptions exportOptions,
			PublishOptions publishConfigOptions)
			throws ExportMSPServiceException;

}
