//------------------------------------------------------------------------------
// Copyright (c) 2004, 2005 IBM Corporation.  All Rights Reserved.
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp.test;

import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;

import org.eclipse.epf.msproject.DocumentRoot;
import org.eclipse.epf.msproject.Project;
import org.eclipse.epf.msproject.MsprojectFactory;
import org.eclipse.epf.msproject.MsprojectPackage;
import org.eclipse.epf.msproject.Task;
import org.eclipse.epf.msproject.Tasks;
import org.eclipse.epf.msproject.util.MsprojectResourceFactoryImpl;

/**
 *
 *
 * @author Bing Xu
 * @since 1.0
 */
public class CreateMSProject {

	public static void main(String[] args) {

		MsprojectPackage projectPackage = MsprojectPackage.eINSTANCE;
		MsprojectFactory projectFactory = MsprojectFactory.eINSTANCE;

		EClass projectClass = projectPackage.getProject();
		System.out.println("$$$ TRACE: " + projectClass);

		DocumentRoot docRoot = (DocumentRoot)projectFactory.createDocumentRoot();
		docRoot.getXMLNSPrefixMap().put("", MsprojectPackage.eNS_URI);

//		printClasses(ProjectPackage.eINSTANCE);

		Project aProject = (Project)projectFactory.create(projectClass);
		aProject.setName("Hardcoded Project Name");
		aProject.setCompany("IBM Rational Software");
		aProject.setAuthor("John Smith");
		System.out.println("$$$ TRACE: " + aProject);

		Tasks tasks = projectFactory.createTasks();
		aProject.setTasks(tasks);

		Task aTask = projectFactory.createTask();
		aTask.setName("Activity One");
		aTask.setID(new BigInteger("4"));
		aTask.setStart(new Date());
		aTask.setCritical(true);
		System.out.println("$$$ aProject.getTasks() = " + aProject.getTasks());
		aProject.getTasks().getTask().add(aTask);

		Task bTask = projectFactory.createTask();
		bTask.setName("Sub-Activity One");
		bTask.setID(new BigInteger("5"));
		aProject.getTasks().getTask().add(bTask);

		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*",
				new MsprojectResourceFactoryImpl());

		ResourceSet resSet = new ResourceSetImpl();
		URI fileURI = URI.createFileURI("e:\\tng_data\\MSproject\\emf_msproj_test.xml");

		try {
			// create a new resource for the project

			docRoot.setProject(aProject);
			Resource res = resSet.createResource(fileURI);

			res.getContents().add(docRoot);
			Map options = new HashMap();
			options.put(XMLResource.OPTION_ENCODING, "UTF-8");
			res.save(options);

		} catch(Exception e) {
			e.printStackTrace();
		}

	}

	/**
	   * 13.1.1 Accessing Package Metadata Generically
	   */
	  public static void printClasses(EPackage ePackage)
	  {
	    for (Iterator iter = ePackage.getEClassifiers().iterator(); iter.hasNext(); )
	    {
	      EClassifier classifier = (EClassifier)iter.next();
	      System.out.println(classifier.getName()); System.out.print("  ");

	      if (classifier instanceof EClass)
	      {
	        EClass eClass = (EClass)classifier;
	        for (Iterator aIter = eClass.getEAttributes().iterator(); aIter.hasNext(); )
	        {
	          EAttribute attribute = (EAttribute)aIter.next();
	          System.out.print(attribute.getName() + " ");
	        }
	        for (Iterator rIter = eClass.getEReferences().iterator(); rIter.hasNext(); )
	        {
	          EReference reference = (EReference)rIter.next();
	          System.out.print(reference.getName() + " ");
	        }
	      }
	      else if (classifier instanceof EEnum)
	      {
	        EEnum eEnum = (EEnum)classifier;
	        for (Iterator eIter = eEnum.getELiterals().iterator(); eIter.hasNext(); )
	        {
	          EEnumLiteral literal = (EEnumLiteral)eIter.next();
	          System.out.print(literal.getName() + " ");
	        }
	      }
	      else if (classifier instanceof EDataType)
	      {
	        EDataType eDataType = (EDataType)classifier;
	        System.out.print(eDataType.getInstanceClassName() + " ");
	      }

	      System.out.println();
	    }
	  }
}
