//------------------------------------------------------------------------------
// Copyright (c) 2004, 2005 IBM Corporation.  All Rights Reserved.
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp.test;


import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import org.eclipse.epf.msproject.Assignment;
import org.eclipse.epf.msproject.DocumentRoot;
import org.eclipse.epf.msproject.PredecessorLink;
import org.eclipse.epf.msproject.Project;
import org.eclipse.epf.msproject.MsprojectFactory;
import org.eclipse.epf.msproject.MsprojectPackage;
import org.eclipse.epf.msproject.Task;
import org.eclipse.epf.msproject.util.MsprojectResourceFactoryImpl;


/**
 *
 *
 * @author Bing Xu
 * @since 1.0
 */
public class ReadAddExport {

	public static void main(String[] args) {

		MsprojectPackage projectPackage = MsprojectPackage.eINSTANCE;
		MsprojectFactory projectFactory = MsprojectFactory.eINSTANCE;

		EClass projectClass = projectPackage.getProject();
		System.out.println("$$$ TRACE: " + projectClass);

		DocumentRoot docRoot = (DocumentRoot)projectFactory.createDocumentRoot();
		docRoot.getXMLNSPrefixMap().put("", MsprojectPackage.eNS_URI);

		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*",
				new MsprojectResourceFactoryImpl());

		ResourceSet resSet = new ResourceSetImpl();
		URI fileURI = URI.createFileURI("e:\\tng_data\\MSproject\\emf_msproj_test.xml");

		try {

			Resource res = resSet.getResource(fileURI, true);
			docRoot = (DocumentRoot)res.getEObject("/");
			Project proj = (Project)docRoot.getProject();

			printMspBS(proj);

			EList tasks = proj.getTasks().getTask();
			Task firstTask = (Task)tasks.get(3);
			System.out.println("$$$ predecessor = " + firstTask.getPredecessorLink());

			Task aTask = projectFactory.createTask();
			aTask.setOutlineLevel(new BigInteger("1"));
			aTask.setUID(new BigInteger("4"));
			aTask.setID(new BigInteger("4"));
			aTask.setType(new BigInteger("1"));
			aTask.setStart(new Date());
			aTask.setSummary(false);
			aTask.setConstraintType(new BigInteger("2"));
			aTask.setName("RMC Summary Activity");
			PredecessorLink preLink = projectFactory.createPredecessorLink();
			aTask.getPredecessorLink().add(preLink);
			preLink.setPredecessorUID(new BigInteger("3"));
			preLink.setType(new BigInteger("1"));
			preLink.setCrossProject(false);
			preLink.setLinkLag(new BigInteger("0"));
			preLink.setLagFormat(new BigInteger("7"));


			proj.getTasks().getTask().add(aTask);
			System.out.println("$$$ predecessor = " + aTask.getPredecessorLink());

			res.save(null);
			res.unload();

			res = resSet.getResource(fileURI, true);
			docRoot = (DocumentRoot)res.getEObject("/");
			proj = (Project)docRoot.getProject();

			printMspBS(proj);

		} catch(Exception e) {
			e.printStackTrace();
		}

	}

	private static void printMspBS(Project proj) {
		System.out.println("\n$$$ read-in project = " + proj);
		EList tasks = proj.getTasks().getTask();
		for (Iterator iter = tasks.iterator(); iter.hasNext();) {
			Task element = (Task) iter.next();
			System.out.println("$$$ a task = " + element);

		}
		EList resources = proj.getResources().getResource();
		for (Iterator iter = resources.iterator(); iter.hasNext();) {
			org.eclipse.epf.msproject.Resource element = (org.eclipse.epf.msproject.Resource) iter.next();
			System.out.println("$$$ a resource = " + element);

		}
		EList assignments = proj.getAssignments().getAssignment();
		for (Iterator iter = assignments.iterator(); iter.hasNext();) {
			Assignment element = (Assignment) iter.next();
			System.out.println("$$$ an assignment = " + element);

		}

		System.out.println("$$$===\n");
	}

	/**
	   * 13.1.1 Accessing Package Metadata Generically
	   */
	  public static void printClasses(EPackage ePackage)
	  {
	    for (Iterator iter = ePackage.getEClassifiers().iterator(); iter.hasNext(); )
	    {
	      EClassifier classifier = (EClassifier)iter.next();
	      System.out.println(classifier.getName()); System.out.print("  ");

	      if (classifier instanceof EClass)
	      {
	        EClass eClass = (EClass)classifier;
	        for (Iterator aIter = eClass.getEAttributes().iterator(); aIter.hasNext(); )
	        {
	          EAttribute attribute = (EAttribute)aIter.next();
	          System.out.print(attribute.getName() + " ");
	        }
	        for (Iterator rIter = eClass.getEReferences().iterator(); rIter.hasNext(); )
	        {
	          EReference reference = (EReference)rIter.next();
	          System.out.print(reference.getName() + " ");
	        }
	      }
	      else if (classifier instanceof EEnum)
	      {
	        EEnum eEnum = (EEnum)classifier;
	        for (Iterator eIter = eEnum.getELiterals().iterator(); eIter.hasNext(); )
	        {
	          EEnumLiteral literal = (EEnumLiteral)eIter.next();
	          System.out.print(literal.getName() + " ");
	        }
	      }
	      else if (classifier instanceof EDataType)
	      {
	        EDataType eDataType = (EDataType)classifier;
	        System.out.print(eDataType.getInstanceClassName() + " ");
	      }

	      System.out.println();
	    }
	  }

}
