//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp.ui.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ui.wizards.ExportOptionContribution;
import org.eclipse.epf.export.msp.ui.wizards.IExportMSPWizardExtender;

/**
 * Manages the "org.eclipse.epf.export.msp.exportMSPWizard" extension point.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class ExportMSPWizardExtensionManager {

	/**
	 * The extension point namespace.
	 */
	public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.export.msp"; //$NON-NLS-1$

	/**
	 * The extension point name.
	 */
	public static final String EXTENSION_POINT_NAME = "exportMSPWizard"; //$NON-NLS-1$

	// An extender of the Export MSP wizard.
	private IExportMSPWizardExtender wizardExtender;

	// The shared instance.
	private static ExportMSPWizardExtensionManager instance = new ExportMSPWizardExtensionManager();

	/**
	 * Creates a new instance.
	 */
	private ExportMSPWizardExtensionManager() {
		processExtensionPoint();
	}

	/**
	 * Returns the shared instance.
	 * 
	 * @return the shared instance
	 */
	public static ExportMSPWizardExtensionManager getInstance() {
		return instance;
	}

	/**
	 * Processes the "org.eclipse.epf.export.msp.exportMSPWizard" extension
	 * point.
	 */
	protected void processExtensionPoint() {
		IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(
				EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
		if (extensionPoint != null) {
			IExtension[] extensions = extensionPoint.getExtensions();
			for (int i = 0; i < extensions.length; i++) {
				IExtension extension = extensions[i];
				IConfigurationElement[] configElements = extension
						.getConfigurationElements();
				for (int j = 0; j < configElements.length; j++) {
					IConfigurationElement configElement = configElements[j];
					try {
						IExportMSPWizardExtender extender = (IExportMSPWizardExtender) configElement
								.createExecutableExtension("class"); //$NON-NLS-1$
						if (wizardExtender == null) {
							wizardExtender = extender;

							IConfigurationElement[] childConfigElements = configElement
									.getChildren("exportOption"); //$NON-NLS-1$
							for (int k = 0; k < childConfigElements.length; k++) {
								IConfigurationElement childConfigElement = childConfigElements[k];
								String name = childConfigElement
										.getAttribute("name"); //$NON-NLS-1$
								String description = childConfigElement
										.getAttribute("description"); //$NON-NLS-1$
								String defaultSelectionAttr = childConfigElement
										.getAttribute("defaultSelection"); //$NON-NLS-1$
								boolean defaultSelection = Boolean
										.getBoolean(defaultSelectionAttr);
								if (name != null && name.length() > 0
										&& description != null
										&& description.length() > 0) {
									wizardExtender
											.addExportOptionContribution(new ExportOptionContribution(
													name, description,
													defaultSelection));
								}
							}

							return;
						}
					} catch (Exception e) {
						ExportMSPPlugin.getDefault().getLogger().logError(e);
					}
				}
			}
		}
	}

	/**
	 * Gets the Export MSP wizard extender loaded via the
	 * "org.eclipse.epf.export.msp.exportMSPWizard" extension point.
	 * 
	 * @return an Export MSP wizard extender or <code>null</code>
	 */
	public IExportMSPWizardExtender getWizardExtender() {
		return wizardExtender;
	}

}
