//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp.ui.wizards;

import java.util.List;
import java.util.Map;

import org.eclipse.epf.export.msp.IExportMSPService;
import org.eclipse.jface.wizard.IWizardPage;

/**
 * The interface for an extender of the Export Microsoft Project wizard.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public interface IExportMSPWizardExtender {

	/**
	 * Allows a wizard extender to contribute additional pages to the base
	 * wizard.
	 * 
	 * @return a list of <ocde>IWizardPage</code>
	 */
	public List getPageContributions();

	/**
	 * Allows a wizard extender to modify the flow of the wizard pages.
	 * 
	 * @param page
	 *            the current wizard page
	 * @return the next wizard page
	 */
	public IWizardPage getNextPage(IWizardPage page);

	/**
	 * Allows a wizard extender to decide whether the wizard could be finished
	 * without further user interaction.
	 * 
	 * @return <code>true</code> if the wizard could be finished
	 */
	public boolean canFinish();

	/**
	 * Adds an export option contribution to this wizard extender.
	 * 
	 * @param contribution
	 *            a <code>ExportOptionContribution</code>
	 */
	public void addExportOptionContribution(
			ExportOptionContribution contribution);

	/**
	 * Allows a wizard extender to contribute additional export options to the
	 * wizard.
	 * 
	 * @return a collection of <code>ExportOptionContribution</code>
	 */
	public List getExportOptionContributions();

	/**
	 * Allows a wizard extender to specify additional export options before the
	 * export operation is executed.
	 * 
	 * @return a collection of export options
	 */
	public Map getExportOptions();

	/**
	 * Allows a wizard extender to provide an alternative implementation of the
	 * service that will be executed when the wizard finishes.
	 * 
	 * @return an <code>IExportMSPService</code> instance
	 */
	public IExportMSPService getExportMSPService();

}
