//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp.ui.wizards;

import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ExportMSPResources;
import org.eclipse.epf.export.msp.ui.preferences.ExportMSPPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

/**
 * A wizard page that prompts the user to specify the project template name and
 * export directory.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class SelectExportDirectoryPage extends WizardPage implements Listener {

	public static final String PAGE_NAME = SelectExportDirectoryPage.class
			.getName();

	private Combo templateNameCombo;

	private Combo templateDirCombo;

	private ModifyListener modifyListener = new ModifyListener() {
		public void modifyText(ModifyEvent e) {
			setPageComplete(isPageComplete());
		}
	};

	/**
	 * Creates a new instance.
	 */
	public SelectExportDirectoryPage() {
		super(PAGE_NAME);
		setTitle(ExportMSPResources.selectExportDirWizardPage_title);
		setDescription(ExportMSPResources.selectExportDirWizardPage_text);
		setImageDescriptor(ExportMSPPlugin.getDefault().getImageDescriptor(
				"full/wizban/ExportMSProject.gif")); //$NON-NLS-1$		
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		final Shell shell = parent.getShell();

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Composite templateComposite = new Composite(composite, SWT.NULL);
		templateComposite.setLayout(new GridLayout(3, false));
		templateComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label templateNameLabel = new Label(templateComposite, SWT.NONE);
		templateNameLabel.setText(ExportMSPResources.projectNameLabel_text);

		templateNameCombo = new Combo(templateComposite, SWT.BORDER);
		templateNameCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		String prevName = ExportMSPPlugin.getDefault().getPreferenceStore()
				.getString(ExportMSPPreferences.TEMPLATE_NAMES);
		if (prevName != null) {
			templateNameCombo.add(prevName);
		}
		templateNameCombo.addModifyListener(modifyListener);

		new Label(templateComposite, SWT.NONE);

		Label dirLabel = new Label(templateComposite, SWT.NONE);
		dirLabel.setText(ExportMSPResources.dirLabel_text);

		templateDirCombo = new Combo(templateComposite, SWT.BORDER);
		templateDirCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		String savedDir = ExportMSPPlugin.getDefault().getPreferenceStore()
				.getString(ExportMSPPreferences.TARGET_DIRECTORIES);
		if (savedDir != null) {
			templateDirCombo.add(savedDir);
			templateDirCombo.setText(savedDir);
		}
		templateDirCombo.addModifyListener(modifyListener);

		Button browseButton = new Button(templateComposite, SWT.NONE);
		browseButton.setText(ExportMSPResources.browseButton_text);
		browseButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				try {
					DirectoryDialog dialog = new DirectoryDialog(shell,
							SWT.NONE);
					String selectedDir = dialog.open();
					if (selectedDir != null) {
						templateDirCombo.add(selectedDir, 0);
						templateDirCombo.setText(selectedDir);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});

		setControl(composite);
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
		setPageComplete(isPageComplete());
		getWizard().getContainer().updateButtons();
	}

	/**
	 * @see org.eclipse.jface.wizard.WizardPage#isCompleted()
	 */
	public boolean isPageComplete() {
		if (templateNameCombo.getText().trim().length() > 0
				&& templateDirCombo.getText().trim().length() > 0) {
			return true;
		}
		return false;
	}

	/**
	 * @see org.eclipse.jface.wizard.WizardPage#getNextPage()
	 */
	public IWizardPage getNextPage() {
		ExportMSPWizard wizard = (ExportMSPWizard) getWizard();
		IExportMSPWizardExtender wizardExtender = wizard.getWizardExtender();
		if (wizardExtender != null) {
			IWizardPage page = wizardExtender.getNextPage(this);
			if (page != null) {
				return page;
			}
		}
		return null;
	}

	/**
	 * Returns the template name.
	 */
	public String getTemplateName() {
		return templateNameCombo.getText();
	}

	/**
	 * Returns the target directory.
	 */
	public String getTargetDirectory() {
		return templateDirCombo.getText();
	}

}