//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.msp.ui.wizards;

import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ExportMSPResources;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.wizards.PublishConfigPublishOptionsPage;
import org.eclipse.jface.wizard.IWizardPage;

/**
 * A wizard page that prompts the user to select the publishing options for the
 * selected configuration.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class SelectPublishOptionsPage extends PublishConfigPublishOptionsPage {

	public static final String PAGE_NAME = SelectPublishOptionsPage.class
			.getName();

	/**
	 * Creates a new instance.
	 */
	public SelectPublishOptionsPage(boolean displayDestinationGroup,
			PublishOptions dataModel) {
		super(PAGE_NAME, displayDestinationGroup, dataModel);
		setTitle(ExportMSPResources.selectPublishOptionsWizardPage_title);
		setDescription(ExportMSPResources.selectPublishOptionsWizardPage_text);
		setImageDescriptor(ExportMSPPlugin.getDefault().getImageDescriptor(
				"full/wizban/ExportMSProject.gif")); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.jface.wizard.WizardPage#getNextPage()
	 */
	public IWizardPage getNextPage() {
		ExportMSPWizard wizard = (ExportMSPWizard) getWizard();
		IExportMSPWizardExtender wizardExtender = wizard.getWizardExtender();
		if (wizardExtender != null) {
			IWizardPage page = wizardExtender.getNextPage(this);
			if (page != null) {
				return page;
			}
		}
		return wizard.selectExportDirPage;
	}

}
