//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.services;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;


/**
 * Encapsulates the input data required to export a method plug-in.
 * 
 * @author Jinhua Xi
 * @author Kelvin Low
 * @since 1.0
 */
public class PluginExportData {

	public List selectedPlugins = null;

	public LibraryLocationData llData = null;

	public Hashtable associatedConfigMap = new Hashtable();

	// don't need it after the service code changes
	public List associatedConfigs = new ArrayList();

	/**
	 * Creates a new instance.
	 */
	public PluginExportData() {
		llData = new LibraryLocationData();
		llData.loadFromPreferenceStore();
	}

	public List getSelectedPlugins() {
		return selectedPlugins;
	}

	public void setSelectedPlugins(List selectedPlugins) {
		this.selectedPlugins = selectedPlugins;
	};

	public boolean validate() {
		return true;
	}

}
