//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.wizards;

import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;


/**
 * A wizard page that prompts the user for the destination directory of an
 * export operation.
 * 
 * @author Bingxue Xu
 * @author Kelvin Low
 * @since 1.0
 */
public class ExportConfigDestinationPage extends DestinationCommonPage {

	public static final String PAGE_NAME = ExportConfigDestinationPage.class
			.getName();

	/**
	 * Creates a new instance.
	 */
	public ExportConfigDestinationPage(ConfigurationExportData data) {
		super(PAGE_NAME, data.llData);
		setTitle(ExportResources.selectDestinationPage_title); //$NON-NLS-1$
		setDescription(ExportResources.selectDestinationPage_desc); //$NON-NLS-1$
		setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor(
				"full/wizban/ExportLibraryConfiguration.gif")); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.jface.wizard.WizardPage#isPageComplete()
	 */
	public boolean isPageComplete() {
		ExportConfigurationWizard wizard = (ExportConfigurationWizard) getWizard();
		if (isTextNonEmpty(ctrl_name) && isTextNonEmpty(ctrl_exportPath)) {
			saveToDataModel();
			wizard.okToComplete = true;
			return true;
		}
		return false;
	}

}
