//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.export.wizards;

import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.PluginExportData;


/**
 * A wizard page that informs the user that changes to the existing method
 * plug-ins will be saved prior to an export operation.
 * 
 * @author Jinhua Xi
 * @author Kelvin Low
 * @since 1.0
 */
public class SavePluginPage extends DestinationCommonPage {

	public static final String PAGE_NAME = SavePluginPage.class.getName();

	/**
	 * Creates a new instance.
	 */
	public SavePluginPage(PluginExportData data) {
		super(PAGE_NAME, data.llData);
		setTitle(ExportResources.specifyPathPage_title); 
		setDescription(ExportResources.specifyPathPage_desc); 
		setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor(
				"full/wizban/ExportMethodPlugins.gif")); //$NON-NLS-1$
	}

	public boolean isPageComplete() {
		ExportPluginWizard wizard = (ExportPluginWizard) getWizard();
		if (isTextNonEmpty(ctrl_name) && isTextNonEmpty(ctrl_exportPath)) {
			saveToDataModel();
			wizard.okToComplete = true;
			return true;
		}
		return false;
	}

}
