//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.importing.xml.services;

import java.io.File;

import org.eclipse.epf.dataexchange.util.BaseResourceHandler;
import org.eclipse.epf.dataexchange.util.UrlInfo;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;


/**
 * resource handler for content in the imported library
 * 
 * @author Jinhua Xi
 * @since 1.0
 *
 */
public class ImportResourceHandler extends BaseResourceHandler {

		
	public ImportResourceHandler(File sourceLibRoot, File targetLibRoot) {
		super(sourceLibRoot, targetLibRoot);
	}
	

	/**
	 * the resource path will be relative to the libary root. urls needs to be fixed
	 * 
	 * @param owner the owner object in the target library
	 * @param srcUrl the url referenced in the source content
	 * @return
	 */
	public UrlInfo loadUrlInfoWithFixedPath(Object owner, String srcUrl) {
		UrlInfo info = new UrlInfo();
		info.sourceUrl = srcUrl;
		info.targetUrl = srcUrl;
		info.sourceFile = new File(sourceLibRoot, srcUrl);
		info.targetFile = new File(targetLibRoot, srcUrl);

		if ( owner instanceof MethodElement)  {
			String backPath = ResourceHelper.getBackPath( (MethodElement)owner);
			info.targetUrl = backPath + srcUrl;
		}
		return info;	
	}
	
	/**
	 * the resource path will be relative to the owner element. 
	 * urls will not be changed but resource files is relicated.
	 * @param owner owner the owner object in the target library
	 * @param srcUrl
	 * @return
	 */
	public UrlInfo loadUrlInfoWithRelativePath(Object owner, String srcUrl) {
		UrlInfo info = new UrlInfo();
		info.sourceUrl = srcUrl;
		info.targetUrl = info.sourceUrl; // no url change
		info.sourceFile = new File(sourceLibRoot, srcUrl);
		
		if ( owner instanceof MethodElement)  {
			//String elementPath = ResourceHelper.getElementResourcePath(owner);
			String elementPath = ResourceHelper.getElementPath( (MethodElement)owner);
			info.targetFile = new File(new File(targetLibRoot, elementPath), srcUrl);			
		}

		return info;
	}
	
}
