//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.importing.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * The content provider for the diff report.
 * 
 * @author Jinhua Xi
 * @since 1.0
 */
public class DiffReportContentProvider implements ITreeContentProvider {

	public DiffReportContentProvider() {
	}

	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof ElementDiffTree) {
			
			MethodElement e = ((ElementDiffTree)inputElement).getBaseElement();
			
			// don't show sub-packages under process component, hide the process detial
			if ( (e instanceof ProcessComponent) ) {
				return new Object[] {};
			}

			List items = ((ElementDiffTree) inputElement).getChildren();
			if (items != null) {
				List dirtyItems = new ArrayList();
				for (Iterator it = items.iterator(); it.hasNext();) {
					ElementDiffTree item = (ElementDiffTree) it.next();
					if (item.isOldOnly()) {
						continue;
					}
					
					// 150895Import Config: CustomCategory did not sync up by import
					// to fix this problem, we need to include the Hidden root customCategory package 
					// but need to hide here
					MethodElement base = item.getBaseElement();
					if ( (base instanceof MethodPackage) 
							&& TngUtil.isRootCutomCategoryPackage((MethodPackage)base) ) {
						continue;
					}
					
					dirtyItems.add(item);
				}

				return dirtyItems.toArray();
			}
		}
		return new Object[] {};
	}

	public void dispose() {
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}

	public Object[] getChildren(Object parentElement) {
		return getElements(parentElement);
	}

	public Object getParent(Object element) {
		if (element instanceof ElementDiffTree) {
			return ((ElementDiffTree) element).getParent();
		}
		return null;
	}

	public boolean hasChildren(Object element) {
		if (element instanceof ElementDiffTree) {
			return ((ElementDiffTree) element).hasChildren();
		}
		return false;
	}

}
