//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.importing.wizards;

import org.eclipse.epf.importing.ImportPlugin;


/**
* Manages the Publishing UI preferences.
* 
* @author Bingxue Xu
* @since 1.0
*/
public class ImportUIPreferences {

	/**
	 * The Publishing UI preference keys.
	 */
	public static final String LAST_IMPORT_PLUGIN_PATH = "lastImportPluginPath"; //$NON-NLS-1$


	/**
	 * Returns the last import plugin path that was saved in a previous session.
	 * 
	 * @return The saved last import plugin path.
	 */
	public static String getLastImportPluginPath() {
		return ImportPlugin.getDefault().getPreferenceStore().getString(
				LAST_IMPORT_PLUGIN_PATH);
	}

	/**
	 * Saves the current import plugin path to preference store.
	 * 
	 * @param path
	 *            A import plugin path.
	 */
	public static void setLastImportPluginPath(String path) {
		ImportPlugin.getDefault().getPreferenceStore().setValue(
				LAST_IMPORT_PLUGIN_PATH, path);
	}

}
