//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.importing.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.osgi.util.NLS;


public class PluginModifyInfo {

	public List lockedPlugins = new ArrayList();
	public List readonlyPlugins = new ArrayList();
	
	PluginModifyInfo() {
		
	}

	public StringBuffer getLockedMessage() {
		StringBuffer buffer = new StringBuffer();
		for (Iterator it = lockedPlugins.iterator(); it.hasNext(); ) {
			MethodPlugin plugin = (MethodPlugin)it.next();
			String msg = NLS.bind(ImportResources.SelectImportConfigurationSource_plugin_locked, plugin.getName()); 
			buffer.append(msg);
		}
		
		return buffer;
	}
	
	public StringBuffer getReadonlyMessage() {
		StringBuffer buffer = new StringBuffer();
		for (Iterator it = readonlyPlugins.iterator(); it.hasNext(); ) {
			MethodPlugin plugin = (MethodPlugin)it.next();
			String msg = NLS.bind(ImportResources.SelectImportConfigurationSource_plugin_readonly, plugin.getName()); 
			buffer.append(msg);
		}
		
		return buffer;
	}
}
