//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.importing.wizards;

import java.io.File;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.export.wizards.DestinationCommonPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;


/**
 * A wizard page that prompts the user to select a directory that contains the
 * method plug-ins to import.
 * 
 * @author Jeff Hardy
 * @author Kelvin Low
 * @since 1.0
 */
public class SelectImportPluginSource extends DestinationCommonPage {

	public static final String PAGE_NAME = SelectImportPluginSource.class
			.getName();

	private static final Status OK_STATUS = new Status(
			IStatus.OK,
			ImportResources.SelectImportPluginSource_not_used, 0, "", null); //$NON-NLS-1$ //$NON-NLS-2$

	private PluginImportData data;

	private PluginImportingService service;

	private Status status = OK_STATUS;

	/**
	 * Creates a new instance.
	 */
	public SelectImportPluginSource(PluginImportData data,
			PluginImportingService service) {
		super(PAGE_NAME, data.llData);
		setTitle(ImportResources.selectPluginsDirWizardPage_title); //$NON-NLS-1$
		setDescription(ImportResources.selectPluginsDirWizardPage_text); //$NON-NLS-1$
		setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor(
				"full/wizban/ImportMethodPlugins.gif")); //$NON-NLS-1$
		this.service = service;
		this.data = data;
	}

	public void createControl(Composite parent) {
		super.createControl(parent);
		
		String savedPath = ImportUIPreferences.getLastImportPluginPath();
		if (savedPath != null && savedPath.length() > 0){
			ctrl_exportPath.setText(savedPath);
			ctrl_exportPath.setEditable(true);
			ctrl_browse_button.setEnabled(true);
			ctrl_default_checkbox.setSelection(false);
		}
		
		ctrl_default_checkbox.addListener(SWT.Selection, this);
	}
	
	public void handleEvent(Event event) {
		
		super.handleEvent(event);
		
		Wizard wizard = (Wizard) getWizard();

		if (event.widget == ctrl_default_checkbox) {
			if (!ctrl_default_checkbox.getSelection()) {
				ctrl_name.setText(""); //$NON-NLS-1$
				String savedPath = ImportUIPreferences.getLastImportPluginPath();
				if (savedPath != null && savedPath.length() > 0){
					ctrl_exportPath.setText(savedPath);
			
				}
				ctrl_exportPath.setEditable(true);
				ctrl_browse_button.setEnabled(true);
	
			}
		}
		setPageComplete(isPageComplete());
		wizard.getContainer().updateButtons();

	}
	/**
	 * @see org.eclipse.jface.wizard.WizardPage#isCompleted()
	 */
	public boolean isPageComplete() {
		boolean returnValue = false;
		status = OK_STATUS;
		if (isTextNonEmpty(ctrl_name) && isTextNonEmpty(ctrl_exportPath)) {
			saveToDataModel();
			File libDir = new File(ctrl_exportPath.getText());
			if (!libDir.exists()) {
				status = new Status(
						IStatus.ERROR,
						ImportResources.SelectImportPluginSource_not_used, 0, ImportResources.SelectImportPluginSource_no_path, null); 
			} else {
				returnValue = true;
			}
		}
		applyToStatusLine();
		return returnValue;
	}

	protected void saveToDataModel() {
		super.saveToDataModel();
		data.llData.setLibName(ctrl_name.getText());
		data.llData.setParentFolder(ctrl_exportPath.getText());
	}

	public IWizardPage getNextPage() {
		saveToDataModel();

		// Validate first before going to the next page.
		service.validate(null);
		String error = data.getErrorInfo().getError();
		if (error != null && error.length() > 0) {
			super.setErrorMessage(error);
			return this;
		} else {
			SelectPluginsToImport page = ((ImportPluginWizard) getWizard()).page2;
			page.onEnterPage();
			return page;
		}
	}

	public boolean canFlipToNextPage() {
		return isPageComplete();
	}

	private void applyToStatusLine() {
		if (status != OK_STATUS)
			setErrorMessage(status.getMessage());
		else {
			setErrorMessage(null);
		}
	}

}
