//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.edit.validation;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.NamedElement;


/**
 * @author Phong Nguyen Le - Aug 4, 2005
 * @since 1.0
 */
public interface IValidatorFactory {
	public static final IValidatorFactory INSTANCE = new ValidatorFactory();

	IValidator createNameValidator(NamedElement e, AdapterFactory adapterFactory);

	/**
	 * Creates name validator for a content element
	 * 
	 * @param e
	 * @return
	 */
	IValidator createNameValidator(Object parent, ContentElement e);

	/**
	 * Creates name validator for a element
	 * 
	 * @param e
	 * @return
	 */
	IValidator createNameValidator(Object parent, NamedElement e);

	IValidator createPresentationNameValidator(Object parent,
			DescribableElement e);
	
	/**
	 * Creates a validator for the value targeted for given feature of the given object
	 * 
	 * @param parent
	 * @param feature
	 * @param value
	 * @return
	 */
	IValidator createValidator(EObject object, EStructuralFeature feature, Object value);
}
