//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.edit.validation.internal;

import java.io.File;

import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;


/**
 * @author Phong Nguyen Le - May 12, 2006
 * @since  1.0
 */
public class MethodConfigurationNameValidator implements IValidator {

	private MethodLibrary library;
	private MethodConfiguration config;

	public MethodConfigurationNameValidator(MethodLibrary lib, MethodConfiguration config) {
		library = lib;
		this.config = config;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.epf.library.edit.validation.IValidator#isValid(java.lang.String)
	 */
	public String isValid(String newText) {
		File dir = new File(new File(library.eResource().getURI().toFileString())
						.getParent(), ContentDescriptionFactory.getMethodLibraryPersister().getFolderRelativePath(config));
		return TngUtil.checkName(dir, library.getPredefinedConfigurations(), config,
				newText, TngUtil.getTypeText(config), false);
	}
}
