//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.edit.validation.internal;

import java.io.File;

import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;


/**
 * Validates the name of a process component.
 * 
 * @author Phong Nguyen Le
 * @author Kelvin Low
 * @since 1.0
 */
public class ProcessComponentNameValidator implements IValidator {

	private ProcessPackage parent;

	private ProcessComponent procComp;

	/**
	 * Creates a new instance.
	 */
	public ProcessComponentNameValidator(ProcessPackage parent,
			ProcessComponent procComp) {
		this.parent = parent;
		this.procComp = procComp;
	}

	/**
	 * @see org.eclipse.epf.library.edit.validation.IValidator#isValid(java.lang.String)
	 */
	public String isValid(String newText) {
		String relativePath = ContentDescriptionFactory
				.getMethodLibraryPersister().getFolderRelativePath(procComp);
		MethodPlugin plugin = UmaUtil.getMethodPlugin(parent);
		File dir = new File(
				new File(plugin.eResource().getURI().toFileString())
						.getParent()
						+ File.separator + relativePath);
		return TngUtil.checkName(dir, parent.getChildPackages(), procComp,
				newText, TngUtil.getTypeText(procComp), true);
	}

}
