//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.persistence;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

/**
 * @author Phong Nguyen Le - Aug 9, 2006
 * @since  1.0
 */
public class ExtendedResourceSet extends MultiFileResourceSetImpl {
	protected MultiFileResourceSetImpl referencedResourceSet;

	/**
	 * Creates an {@link ExtendedResourceSet} that can have reference to objects in the given resource set 
	 */
	public ExtendedResourceSet(MultiFileResourceSetImpl referencedResourceSet) {
		super();
		this.referencedResourceSet = referencedResourceSet;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.epf.persistence.MultiFileResourceSetImpl#getEObject(org.eclipse.emf.ecore.EObject, org.eclipse.emf.common.util.URI, boolean)
	 */
	public EObject getEObject(EObject resolver, URI uri, boolean loadOnDemand) {
		EObject object = null;
		UnnormalizedURIException ex = null;
		try {
			object = super.getEObject(resolver, uri, loadOnDemand);
		}
		catch(UnnormalizedURIException e) {
			ex = e;
		}
		if(object != null) {
			return object;
		}
		try {
			object = referencedResourceSet.getEObject(resolver, uri, loadOnDemand);
		}
		catch(UnnormalizedURIException e) {
			ex = e;
		}
		if(object != null) {
			return object;
		}
		else if(ex != null) {
			throw ex;
		}
		return object;
	}
}
