//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.persistence.refresh.internal;

import java.util.Collection;

import org.eclipse.epf.persistence.refresh.IRefreshEvent;

/**
 * @author Phong Nguyen Le
 * @since 1.0
 */
public class RefreshEvent implements IRefreshEvent {

	private Collection refreshedResources;

	private Collection unloadedObjects;

	public RefreshEvent(Collection refreshedResources,
			Collection unloadedObjects) {
		this.refreshedResources = refreshedResources;
		this.unloadedObjects = unloadedObjects;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.epf.persistence.refresh.IRefreshEvent#getRefreshedResources()
	 */
	public Collection getRefreshedResources() {
		return refreshedResources;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.epf.persistence.refresh.IRefreshEvent#getUnloadedObjects()
	 */
	public Collection getUnloadedObjects() {
		return unloadedObjects;
	}

}
