//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.persistence.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.epf.uma.MethodLibrary;

/**
 * @author Phong Nguyen Le - Aug 15, 2006
 * @since  1.0
 */
public class LibrarySchedulingRule implements ISchedulingRule {
	private MethodLibrary library;

	/**
	 * @param lib
	 */
	public LibrarySchedulingRule(MethodLibrary lib) {
		this.library = lib;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.jobs.ISchedulingRule#contains(org.eclipse.core.runtime.jobs.ISchedulingRule)
	 */
	public boolean contains(ISchedulingRule rule) {
		if(this == rule) {
			return true;
		}
		if(rule instanceof LibrarySchedulingRule) {
			return ((LibrarySchedulingRule)rule).library == library;
		}
		
		// allow any IResource rule to nest within the same thread
		//
		return rule instanceof IResource;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.jobs.ISchedulingRule#isConflicting(org.eclipse.core.runtime.jobs.ISchedulingRule)
	 */
	public boolean isConflicting(ISchedulingRule rule) {
		return equals(rule);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		return this == obj || (obj instanceof LibrarySchedulingRule && ((LibrarySchedulingRule)obj).library == library);
	}

}
