//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.persistence.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.migration.internal.Migrator;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.UmaPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/**
 * @author Phong Nguyen Le
 * @since 1.0
 */
public class PersistenceUtil {

	/**
	 * Gets the current namespace URI of UMA.
	 */
	public static final String getUMANsURI() {
		for (Iterator iter = EPackage.Registry.INSTANCE.entrySet().iterator(); iter
				.hasNext();) {
			Map.Entry entry = (Map.Entry) iter.next();
			if (entry.getValue() instanceof UmaPackage) {
				return entry.getKey().toString();
			}
		}
		return null;
	}

	public static final String getUMANsURI(String libPath) {
		try {
			DocumentBuilder builder = DocumentBuilderFactory.newInstance()
					.newDocumentBuilder();
			Document doc = builder.parse(new File(libPath));
			Element root = doc.getDocumentElement();
			String nsURI = root.getAttribute("xmlns:com.ibm.uma"); //$NON-NLS-1$
			if (nsURI == null || nsURI.equals("")) { //$NON-NLS-1$
				nsURI = root.getAttribute("xmlns:org.eclipse.epf.uma"); //$NON-NLS-1$
			}
			return nsURI;
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (FactoryConfigurationError e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static final boolean conversionRequired(String libPath) {
		String currentNsURI = PersistenceUtil.getUMANsURI();
		String libNsURI = PersistenceUtil.getUMANsURI(libPath);
		if (currentNsURI.equals(libNsURI))
			return false;
		if (Migrator.OLD_UMA_NS_URI.equals(libNsURI))
			return true;
		return false;
	}

	public static final IResource getWorkspaceResource(Object obj) {
		Resource resource = null;
		if (obj instanceof ContentElement) {
			ContentElement e = (ContentElement) obj;
			ContentDescription content = e.getPresentation();
			resource = content.eResource();
			if (resource == null) {
				resource = e.eResource();
			}
		} else if (obj instanceof EObject) {
			resource = ((EObject) obj).eResource();
		}
		if (resource != null) {
			return FileManager.getResourceForLocation(resource.getURI()
					.toFileString());
		}
		return null;
	}

	public static final Collection getProxies(EObject obj) {
		Collection proxies = new ArrayList();
		for (Iterator iter = obj.eAllContents(); iter.hasNext();) {
			EObject o = (EObject) iter.next();
			if (o.eIsProxy()) {
				proxies.add(o);
			}
		}
		return proxies;
	}

}