//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.ui;

import org.eclipse.osgi.util.NLS;

public class LibraryUIResources extends NLS {

	private static String BUNDLE_NAME = LibraryUIResources.class
			.getPackage().getName()
			+ ".Resources"; //$NON-NLS-1$
	
	public static String activity_text;
	public static String artifact_text;
	public static String capabilityPattern_text;
	public static String checklist_text;
	public static String checkItem_text;
	public static String compositeRole_text;
	public static String concept_text;
	public static String contentPackage_text;
	public static String customCategory_text;
	public static String deliverable_text;
	public static String deliveryProcess_text;
	public static String descriptor_text;
	public static String discipline_text;
	public static String disciplineGrouping_text;
	public static String domain_text;
	public static String estimate_text;
	public static String estimatingMetric_text;
	public static String estimationConsiderations_text;
	public static String example_text;
	public static String guidance_text;
	public static String guideline_text;
	public static String iteration_text;
	public static String methodConfiguration_text;
	public static String methodContent_text;
	public static String methodLibrary_text;
	public static String methodPackage_text;
	public static String methodPlugin_text;
	public static String milestone_text;
	public static String outcome_text;
	public static String phase_text;
	public static String practice_text;
	public static String process_text;
	public static String processContribution_text;
	public static String processFamily_text;
	public static String processPackage_text;
	public static String report_text;
	public static String reusableAsset_text;
	public static String roadmap_text;
	public static String roleDescriptor_text;
	public static String role_text;
	public static String roleSet_text;
	public static String roleSetGrouping_text;
	public static String standardCategory_text;
	public static String step_text;
	public static String supportingMaterial_text;
	public static String task_text;
	public static String taskDescriptor_text;
	public static String teamProfile_text;
	public static String template_text;
	public static String termDefinition_text;
	public static String tool_text;
	public static String toolMentor_text;
	public static String whitepaper_text;
	public static String workProduct_text;
	public static String workProductDescriptor_text;
	public static String workProductElement_text;
	public static String workProductType_text;
	
	public static String activity_text_plural;
	public static String artifact_text_plural;
	public static String capabilityPattern_text_plural;
	public static String checklist_text_plural;
	public static String checkItem_text_plural;
	public static String compositeRole_text_plural;
	public static String concept_text_plural;
	public static String contentPackage_text_plural;
	public static String customCategory_text_plural;
	public static String deliverable_text_plural;
	public static String deliveryProcess_text_plural;
	public static String descriptor_text_plural;
	public static String discipline_text_plural;
	public static String disciplineGrouping_text_plural;
	public static String domain_text_plural;
	public static String estimate_text_plural;
	public static String estimatingMetric_text_plural;
	public static String estimationConsiderations_text_plural;
	public static String example_text_plural;
	public static String guidance_text_plural;
	public static String guideline_text_plural;
	public static String iteration_text_plural;
	public static String methodConfiguration_text_plural;
	public static String methodContent_text_plural;
	public static String methodLibrary_text_plural;
	public static String methodPackage_text_plural;
	public static String methodPlugin_text_plural;
	public static String milestone_text_plural;
	public static String outcome_text_plural;
	public static String phase_text_plural;
	public static String practice_text_plural;
	public static String process_text_plural;
	public static String processContribution_text_plural;
	public static String processFamily_text_plural;
	public static String processPackage_text_plural;
	public static String report_text_plural;
	public static String reusableAsset_text_plural;
	public static String roadmap_text_plural;
	public static String roleDescriptor_text_plural;
	public static String role_text_plural;
	public static String roleSet_text_plural;
	public static String roleSetGrouping_text_plural;
	public static String standardCategory_text_plural;
	public static String step_text_plural;
	public static String supportingMaterial_text_plural;
	public static String task_text_plural;
	public static String taskDescriptor_text_plural;
	public static String teamProfile_text_plural;
	public static String template_text_plural;
	public static String termDefinition_text_plural;
	public static String tool_text_plural;
	public static String toolMentor_text_plural;
	public static String whitepaper_text_plural;
	public static String workProduct_text_plural;
	public static String workProductDescriptor_text_plural;
	public static String workProductElement_text_plural;
	public static String workProductType_text_plural;
	
	public static String application_title;
	
	public static String openLibraryDialog_title;
	public static String openLibraryDialogArea_title;
	public static String openLibraryDialogArea_text;
	public static String libraryLabel_text;
	public static String browseButton_text;
	public static String promptForLibraryCheckbox_text;
	public static String openLibraryDialog_newLibrary_text;
	
	public static String selectLibraryFolderDialog_title;
	public static String selectLibraryFolderDialog_text;
	
	public static String openingLibraryTask_name;
	
	public static String invalidLibraryPath_msg;
	public static String invalidLibraryPath_reason;
	
	public static String libraryLocked_msg;
	public static String libraryLocked_openButton_text;
	
	public static String readOnlyProjectFile_text;
	public static String retryButton_text;
	public static String cancelButton_text;
	
	public static String upgradeLibraryDialog_title;
	public static String upgradeLibraryDialog_text;
	public static String upgradingLibraryTask_name;
	public static String upgradeLibraryError_msg;
	
	public static String switchConfigDialog_title;
	public static String switchConfigDialog_text;
	
	public static String currentConfigLabel_text;
	public static String selectConfigLabel_text;
	
	public static String deleteFilesConfirmation_msg;
	public static String deleteFilesError_reason;
	public static String createPathError_reason;
	public static String invalidPath_msg;
	
	public static String backupLibraryDialog_title;
	public static String backupLibraryDialog_text;
	public static String backingUpLibraryTask_name;
	
	public static String pathSelectionError_msg;
	public static String okButton_text;
	public static String skipButton_text;
	
	public static String alwaysButton_text;
	public static String neverButton_text;
	public static String promptButton_text;
	
	public static String linkToURL_name;
	public static String linkToFile_name;
	public static String elementLink_name;
	public static String elementLinkWithType_name;
	public static String elementLinkWithUserText_name;
	
	public static String convertActivityDialog_title;
	public static String convertActivityDialog_text;
	public static String unsupportedActivityType_msg;
	public static String unsupportedActivityType_reason;
	
	public static String versionMismatchDialog_text;
	
	public static String versionMismatchDialog_text_unknown;

	static {
		NLS.initializeMessages(BUNDLE_NAME, LibraryUIResources.class);
	}
	
	/**
	 * Returns the localized string associated with a resource key and formatted
	 * with a given object.
	 * 
	 * @param key
	 *            A resource key.
	 * @param data
	 *            An object.
	 * @return A formatted localized string.
	 */
	public static String bind(String key, Object data) {
		return NLS.bind(key, new Object[] { data });
	}

}