//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * Helper utilities for implementing method library UI.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class LibraryUIUtil {

	/**
	 * Updates the application shell title to display the application name and
	 * the default method library path.
	 */
	public static void updateShellTitle() {
		IWorkbenchWindow window = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		if (window != null) {
			Shell shell = window.getShell();
			if (shell != null) {
				String libPath = LibraryServiceUtil.getCurrentMethodLibraryPath(); 
				String appName = Platform.getProduct().getName();
				String appTitle = NLS.bind(LibraryUIResources.application_title,
						new Object[] { appName, libPath });
				shell.setText(appTitle);
			}
		}
	}

}
