//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.ui.dialogs;

import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;

/**
 * Prompts the user to switch the current Configuration to a recommended
 * Configuration.
 * 
 * @author Jeff Hardy
 * @author Kelvin Low
 * @since 1.0
 */
public class SwitchConfigDialog {

	private MethodConfiguration recommendedConfig;

	private Shell shell;

	/**
	 * Creates a new instance.
	 * 
	 * @param shell
	 *            The parent shell.
	 * @param recommendedConfig
	 *            The recommended configuration.
	 */
	public SwitchConfigDialog(Shell shell, MethodConfiguration recommendedConfig) {
		this.shell = shell;
		this.recommendedConfig = recommendedConfig;
	}

	/**
	 * Displays the dialog iff the given recommendedConfig is different than the
	 * currently selected config
	 * 
	 * returns IDialogConstants.OK_ID if dialog wasn't shown, or if config was
	 * switched returns IDialogConstants.CANCEL_ID if dialog was shown and user
	 * did not click Yes
	 */
	public void execute() {
		if (recommendedConfig == null) {
			return;
		}
		String switchConfigPref = LibraryUIPreferences.getSwitchConfig();
		if (MessageDialogWithToggle.NEVER.equals(switchConfigPref)) {
			// Call this to refresh active part if needed.
			// TODO: Review implementation.
			LibraryService.getInstance().setCurrentMethodConfiguration(
					LibraryService.getInstance()
							.getCurrentMethodConfiguration());
			return;
		}
		if (LibraryService.getInstance().getCurrentMethodConfiguration() != recommendedConfig) {
			String configName = recommendedConfig.getName();
			if (MessageDialogWithToggle.PROMPT.equals(switchConfigPref)) {
				MessageDialogWithToggle dialog = MessageDialogWithToggle
						.openYesNoQuestion(shell,
								LibraryUIResources.switchConfigDialog_title,
								LibraryUIResources
								.bind(
										LibraryUIResources.switchConfigDialog_text,
										configName),
								null, false, LibraryUIPlugin.getDefault()
										.getPreferenceStore(),
								LibraryUIPreferences.PREF_SWITCH_CONFIG);
				if (dialog.getReturnCode() == IDialogConstants.YES_ID) {
					MethodConfiguration config = LibraryServiceUtil
							.getMethodConfiguration(LibraryService
									.getInstance().getCurrentMethodLibrary(),
									configName);
					LibraryService.getInstance().setCurrentMethodConfiguration(
							config);
				} else {
					// Call this to refresh active part if needed.
					// TODO: Review implementation.
					LibraryService.getInstance().setCurrentMethodConfiguration(
							LibraryService.getInstance()
									.getCurrentMethodConfiguration());
				}
			} else if (MessageDialogWithToggle.ALWAYS.equals(switchConfigPref)) {
				MethodConfiguration config = LibraryServiceUtil
						.getMethodConfiguration(LibraryService.getInstance()
								.getCurrentMethodLibrary(), configName);
				LibraryService.getInstance().setCurrentMethodConfiguration(
						config);
			}
		}
	}

}
