//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.ui.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

/**
 * The abstract base class for all Library UI wizard pages.
 * 
 * @author Bingxue Xu
 * @author Kelvin Low
 * @since  1.0
 */
public abstract class BaseWizardPage extends WizardPage {
	
	protected BaseWizardPage(String pageName) {
		super(pageName);
	}
	
	protected BaseWizardPage(String pageName, String title, ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}
	
	/**
	 * Called when entering this wizard page.
	 */
	public void onEnterPage() {
	}
	
	protected static boolean isTextNonEmpty(Text t) {
		String s = t.getText();
		if ((s != null) && (s.trim().length() > 0)) return true;
		return false;
	}
	
	protected Label createLabel(Composite parent, String text, int nCol) {
		Label label = new Label(parent, SWT.NONE);
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = nCol;
		label.setLayoutData(gridData);
		label.setText(text);
		return label;
	}
	
	protected Label createLabel(Composite parent, String text) {
		Label label = new Label(parent, SWT.NONE);
		label.setLayoutData(new GridData());
		label.setText(text);
		return label;
	}
	
	protected Text createText(Composite parent, String defaultText, int widthHint, int nCol) {
		Text text = new Text(parent, SWT.BORDER | SWT.READ_ONLY);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = nCol;
		gd.widthHint = widthHint;
		text.setLayoutData(gd);
		return text;
	}
	
	protected Text createEditableText(Composite parent, String defaultText, int widthHint, int nCol) {
		Text text = new Text(parent, SWT.BORDER);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = nCol;
		gd.widthHint = widthHint;
		text.setLayoutData(gd);
		return text;
	}
	
	protected Text createTextMulti(Composite parent, String defaultText, int widthHint, int heightHint, int nCol) {
		Text text = new Text(parent, SWT.BORDER | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL |SWT.READ_ONLY);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = nCol;
		gd.widthHint = widthHint;
		gd.heightHint = heightHint;
		text.setLayoutData(gd);
		return text;
	}
	
	protected Button createCheckbox(Composite parent, String checkboxText, int nCol) {
	    Button button = new Button(parent, SWT.CHECK);
	    button.setText(checkboxText);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = nCol;
		button.setLayoutData(gd);
		return button;
	}
	
	protected Button createCheckbox(Composite parent, String checkboxText) {
		return createCheckbox(parent, checkboxText, 1);
	}
	
	protected Button createRadioButton(Composite parent, String buttonText, int nCol,  boolean selected) {
		Button radioButton = new Button(parent, SWT.RADIO);
		radioButton.setText(buttonText); 
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = nCol;
		radioButton.setLayoutData(gd);
		radioButton.setSelection(selected);
		return radioButton;
	}
	
	protected Button createCheckButton(Composite parent, String buttonText, boolean selected) {
		Button checkButton = new Button(parent, SWT.CHECK);
		checkButton.setText(buttonText);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		checkButton.setLayoutData(gd);
		checkButton.setSelection(selected);
		return checkButton;
	}
	
	protected CheckboxTableViewer createCheckboxTableViewer(Composite parent, int nCol) {
		CheckboxTableViewer checkboxTableViewer = CheckboxTableViewer.newCheckList(parent, SWT.BORDER |SWT.FILL |SWT.HORIZONTAL);
		Table table = checkboxTableViewer.getTable();
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = nCol;
		gd.widthHint = 360;
		gd.heightHint = 174;
		table.setLayoutData(gd);
		return checkboxTableViewer;
	}
	
	protected TableViewer createTableViewer(Composite parent, int widthHint, int heightHint, int nCol) {
		Table table = new Table(parent, SWT.V_SCROLL | SWT.BORDER);
		GridData gridData = new GridData(GridData.BEGINNING | GridData.FILL_BOTH);
		gridData.horizontalSpan = nCol;
		gridData.widthHint = widthHint;
		gridData.heightHint = heightHint;
		table.setLayoutData(gridData);
		TableViewer tableViewer = new TableViewer(table);
		return tableViewer;
	}
	
	protected TextViewer createTextViewer(Composite parent, int widthHint, int heightHint, int nCol) {
		TextViewer textViewer = new TextViewer(parent, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		StyledText textWidget = textViewer.getTextWidget();
		GridData gridData = new GridData(GridData.BEGINNING | GridData.FILL_BOTH);
		gridData.horizontalSpan = nCol;
		gridData.heightHint = heightHint;
		gridData.widthHint = widthHint;
		textWidget.setLayoutData(gridData);
		return textViewer;
	}
	
	protected TextViewer createTextViewer(Composite parent) {
		return createTextViewer(parent, SWT.DEFAULT, SWT.DEFAULT, SWT.DEFAULT);
	}	
	
	protected void createLine(Composite parent, int ncol) {
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL | SWT.BOLD);
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = ncol;
		line.setLayoutData(gridData);
	}
	
}
