//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.configuration;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;

/**
 * realized attribute feature value
 * 
 * @author Jinhua Xi
 * @since 1.0
 *
 */
public class AttributeFeatureValue extends FeatureValue {

	// map of element and the value
	LinkedHashMap valueMap = new LinkedHashMap();

	public AttributeFeatureValue(MethodElement element, MethodElement ownerElement, Object feature, ElementRealizer realizer) {
		super(element, ownerElement, feature, realizer);
	}
	
	public void add(VariabilityElement owner, Object value) {
		if ( (value == null) || (value instanceof String)
				&& value.toString().trim().length() == 0) {
			return;
		}
		
		// note: owner can be null, this is fine
		valueMap.put(owner, value);
	}

	public int size() {
		return valueMap.size();
	}
	
	public Object getValue() {
		StringBuffer buffer = new StringBuffer();
		for (Iterator it = valueMap.entrySet().iterator(); it.hasNext();) {
			Map.Entry entry = (Map.Entry) it.next();
			MethodElement e = (MethodElement)entry.getKey();
			Object v = entry.getValue();
			
//			if (v == null || v.toString().length() == 0) {
//				continue;
//			}

			if (feature == UmaPackage.eINSTANCE
					.getDescribableElement_PresentationName()) {
				if (size() > 1) {
					// something wrong here, will not happen but put test
					// message here just in case
					if (debug) {
						System.out
								.println("AttributeFeatureValue: Presentation Name get more then one entry: " + LibraryUtil.getTypeName(element)); //$NON-NLS-1$
					}
				}
				return v;
			}

			if (buffer.length() > 0) {
				buffer.append(ConfigurationHelper.ATTRIBUTE_VALUE_SEPERATOR); 
			}

			if (e == element || e == null ) {
				buffer.append(v);
			} else {
				String contentPath = ResourceHelper
						.getElementPath((e instanceof ContentDescription) 
								? (MethodElement) e.eContainer()
								: e);

				String backPath = ResourceHelper
						.getBackPath((element instanceof ContentDescription) 
								? ((ownerElement != null) ? ownerElement
								: (MethodElement) element.eContainer())
								: element);

				buffer.append(ResourceHelper.fixContentUrlPath(v.toString(),
						contentPath, backPath));
			}
		}

		return buffer.toString();
	}


}
