//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.configuration;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;


public class ConfigurationsLabelProvider extends AdapterFactoryLabelProvider {

	MethodConfiguration[] configs = null;

	public ConfigurationsLabelProvider(MethodConfiguration[] configs,
			AdapterFactory adapterFactory) {
		super(adapterFactory);
		this.configs = configs;
	}

	/**
	 * This implements {@link ILabelProvider}.getImage by forwarding it to an
	 * object that implements
	 * {@link IItemLabelProvider#getImage IItemLabelProvider.getImage}
	 */
	public Image getImage(Object object) {
		// by default, return the default image
		return super.getImage(object);
	}

	protected Image getImageFromObject(Object object) {
		return ExtendedImageRegistry.getInstance().getImage(object);
	}

	/**
	 * This implements {@link ILabelProvider}.getText by forwarding it to an
	 * object that implements
	 * {@link IItemLabelProvider#getText IItemLabelProvider.getText}
	 */
	public String getText(Object object) {
		String name = null;
		if (object instanceof MethodElement) {
			// hacking here, need to re-work....
			name = ConfigurationHelper.getName((MethodElement) object,
					configs[0]);
		}

		else if (object instanceof MethodConfiguration) {
			name = ((MethodConfiguration) object).getName();
		}

		if (name == null) {
			name = super.getText(object);
		}
		return name;
	}

}