//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.configuration;

/**
 * An ErrorInfo object holds the error message info caused by an element. The
 * ErrorInfo object is owned by the owner element which has this error
 * 
 * @author Jinhua Xi
 * @since 1.0
 */
public class ErrorInfo {
	
	public static final int NONE = 0;

	public static final int ERROR = 1;

	public static final int WARNING = 2;

	public static final int CHILD_ERROR = 4;

	public static final int CHILD_WARNING = 8;

	// this defines the relationship between the owner element and the cause
	// element
	public static final int REFERENCE_TO = 16;

	public static final int REFERENCED_BY = 32;

	private int errorType;

	private Object ownerElement;

	private Object causeElement;

	private String errorMessage;

	private int relation = 0;

	public ErrorInfo(int errorType, String message, Object ownerElement,
			Object causeElement, int relation) {
		this.ownerElement = ownerElement;
		this.causeElement = causeElement;
		this.errorType = errorType;
		this.errorMessage = message;
		this.relation = relation;
	}

	public int getRelation() {
		return relation;
	}

	public Object getOwnerElement() {
		return ownerElement;
	}

	public Object getCauseElement() {
		return causeElement;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public int getErrorType() {
		return errorType;
	}

	public boolean isError() {
		return (errorType & ERROR) > 0;
	}

	public boolean isWarning() {
		return (errorType & WARNING) > 0;
	}

	public boolean isChildError() {
		return (errorType & CHILD_ERROR) > 0;
	}

	public boolean isChildWarning() {
		return (errorType & CHILD_WARNING) > 0;
	}

}
