//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.configuration;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

/**
 * Helper class to identify the feature value and the owning element. 
 * this helps to identify where the value is coming from. 
 * For example, the realized value can be from the base element as well as contributors
 * 
 * @author Jinhua Xi
 * @since 1.0
 *
 */
abstract class FeatureValue {
	
	protected MethodElement element;  // the element
	protected MethodElement ownerElement;  // the container of the element
	protected Object feature; // EStructrualFeature or Oppositefeature
	protected ElementRealizer realizer = null;
	
	protected static boolean debug = LibraryPlugin.getDefault().isDebugging();

	public FeatureValue(MethodElement element, MethodElement ownerElement, Object feature, ElementRealizer realizer) {
		this.element = element;
		this.ownerElement = ownerElement;
		this.feature = feature;
		this.realizer = realizer;
	}

	abstract public void add(VariabilityElement owner, Object value);
	abstract public int size();
	abstract public Object getValue();
	
	public MethodElement getElement() {
		return element;
	}
	
	public MethodElement getOwnerElement() {
		return ownerElement;
	}
	
	public EStructuralFeature getFeature() {
		if ( feature instanceof EStructuralFeature ) {
			return (EStructuralFeature)feature;
		}
		
		return null;
	}
	
	public OppositeFeature getOppositeFeature() {
		if ( feature instanceof OppositeFeature ) {
			return (OppositeFeature)feature;
		}
		
		return null;
	}
	
	
	public ElementRealizer getRealizer() {
		return realizer;
	}
	
}
