//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;

/**
 * realized feature value for a toMany feature
 * 
 * @author Jinhua Xi
 * @since 1.0
 *
 */
public class ToManyFeatureValue extends FeatureValue {

	List values = new ArrayList();
	
	public ToManyFeatureValue(MethodElement element, MethodElement ownerElement, Object feature, ElementRealizer realizer) {
		super(element, ownerElement, feature, realizer);
	}

	public void add(VariabilityElement owner, Object value) {
		if ( !(value instanceof List) ) {	
			return;
		}
			
		for (Iterator it = ((List) value).iterator(); it.hasNext();) {
			MethodElement e = (MethodElement) it.next();
			MethodElement ce = realizer.realize(e);

			// calculated element can be null if it can't show
			if (ce != null && !values.contains(ce)) {
				values.add(ce);
			}
		}
		
		if ( (owner instanceof ContentElement)
				&& (feature == UmaPackage.eINSTANCE
						.getContentDescription_Sections())) {
			ConfigurationHelper.orderSections((ContentElement) owner, values);
		}
						
	}
	

	public Object getValue() {
		return values;
	}

	public int size() {
		return values.size();
	}
}
