//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.internal;

import org.osgi.framework.Bundle;

/**
 * Models a "libraryManager" configuration element in the
 * "org.eclipse.epf.library.libraryManagers" extension point.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class LibraryManagerElement {

	// The contributing plug-in.
	private Bundle bundle;

	// The library manager class name.
	private String className;

	// The library type identifier.
	private String typeId;

	// The library type display name.
	private String typeName;

	/**
	 * Creates a new instance.
	 * 
	 * @param bundle
	 *            The contributing plug-in.
	 * @param className
	 *            The library manager class name.
	 * @param typeId
	 *            The library type identifier.
	 * @param typeName
	 *            The library type display name.
	 */
	public LibraryManagerElement(Bundle bundle, String className,
			String typeId, String typeName) {
		this.bundle = bundle;
		this.className = className;
		this.typeId = typeId;
		this.typeName = typeName;
	}

	/**
	 * Returns the contributing plug-in.
	 */
	public Bundle getBundle() {
		return bundle;
	}

	/**
	 * Returns the library manager class name.
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * Returns the library type identifier.
	 */
	public String getTypeId() {
		return typeId;
	}

	/**
	 * Returns the library type display name.
	 */
	public String getTypeName() {
		return typeName;
	}

}
