//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.layout;

import java.io.File;

import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;

/**
 * interface for content validator at browsing and publishing
 * 
 * @author Jinhua Xi
 * @since 1.0
 *
 */
public interface IContentValidator {

	public void setPublishDir(String pubDir);

	public boolean showBrokenLinks();
	
	public LinkInfo validateLink(MethodElement owner, String attributes,
			String text, MethodConfiguration config);

	public void logInfo(MethodElement owner, String message);

	public void logMissingReference(MethodElement owner,
			MethodElement refElement);

	public void logMissingReference(MethodElement owner, String guid,
			String linkedText);

	public void logMissingResource(MethodElement owner, File resourceFile,
			String url);

	public void logWarning(MethodElement owner, String message);

	public void logError(MethodElement owner, String message, Throwable th);

	public void logInvalidExternalLink(MethodElement owner, String url,
			String message);

	// general logging methods
	public void logInfo(String message);

	public void logWarning(String message);

	public void logError(String message, Throwable th);

	/**
	 * check if the element is discarded or not
	 * discarded elements will be treated as out side the configursation
	 * 
	 * @param owner MethodElement the owner of the element
	 * @param Object feature EStructuralFeature or OppositeFeature
	 * @param e MethodElement the element to be checked
	 */
	public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e);

	public void setDiscardedElement(MethodElement e);

	public void dispose();
		
	public void addReferencedElement(MethodElement owner, MethodElement e);
		
	public boolean showExtraInfoForDescriptors();

}
