//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.layout;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.uma.MethodConfiguration;



/**
 * The process filter with adaptor factory.
 * 
 * @author Jinhua Xi
 * @since 1.0
 */
public class ProcessAdapterFactoryFilter extends ProcessConfigurator implements
		IAdapterFactoryFilter {

	private ElementLayoutManager.LayoutAdapterFactory factory;

	public ProcessAdapterFactoryFilter(MethodConfiguration methodConfig, ElementLayoutManager.LayoutAdapterFactory factory) {
		super(methodConfig, null);
		this.factory = factory;
	}

	public AdapterFactory getWBSAdapterFactory() {
		return factory.wbsAdapterFactory;
	}

	public AdapterFactory getTBSAdapterFactory() {
		return factory.tbsAdapterFactory;
	}

	public AdapterFactory getWPBSAdapterFactory() {
		return factory.wpbsAdapterFactory;
	}

	public AdapterFactory getCBSAdapterFactory() {
		return factory.cbsAdapterFactory;
	}

	public boolean accept(Object obj) {
		return super.accept(obj);
	}

}
