//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.layout.elements;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.uma.DescriptorDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;

/**
 * base layout class for descriptors
 * 
 * @author Jinhua Xi
 * @since 1.0
 */
public abstract class DescriptorLayout extends AbstractProcessElementLayout {

	MethodElement linkedElement = null;

	AbstractElementLayout elementLayout = null;

	protected void __init(ElementLayoutManager layoutManager,
			MethodElement element) {
		super.__init(layoutManager, element);

		if (element instanceof TaskDescriptor) {
			linkedElement = ((TaskDescriptor) element).getTask();
			if (linkedElement != null) {
				elementLayout = new TaskLayout();
			}
		} else if (element instanceof RoleDescriptor) {
			linkedElement = ((RoleDescriptor) element).getRole();
			if (linkedElement != null) {
				elementLayout = new RoleLayout();
			}
		} else if (element instanceof WorkProductDescriptor) {
			linkedElement = ((WorkProductDescriptor) element).getWorkProduct();
			if (linkedElement != null) {
				elementLayout = new WorkProductLayout();
			}
		}

		if (elementLayout != null) {
			elementLayout.init(layoutManager, linkedElement);
			elementLayout.setContentTarget(element);
		}
	}

	/**
	 * for descriptors, if the attribute is not defined, get from the libed
	 * element
	 */
	public Object getAttributeFeatureValue(EStructuralFeature feature) {
		Object value = super.getAttributeFeatureValue(feature);
		if ((elementLayout == null) || (value != null)
				&& (value.toString().length() > 0)) {
			return value;
		}

		// if the attribute is not defined, grab the attribute value from the
		// linked element
		// specified attributes only. Add more feature here if needed
		if (feature == UmaPackage.eINSTANCE.getMethodElement_BriefDescription()) {
			return elementLayout.getAttributeFeatureValue(feature);
		}

		return value;
	}

	/**
	 * get the layout for a child element of this element
	 * ActivityElementLayout should override this method to create layout with node path
	 * @param child
	 * @return IElementLayout
	 */
	protected IElementLayout getChildLayout(MethodElement child)
	{
		if ( layoutManager.getValidator().showExtraInfoForDescriptors() 
				&& (child instanceof DescriptorDescription) ) {
			DescriptorDescriptionLayout l = new DescriptorDescriptionLayout(this.element);
			l.init(layoutManager, child);
			return l;
		} else {
			return layoutManager.getLayout(child, true);
		}
	}
}
