//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.layout.elements;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.epf.library.util.ResourceHelper;

/**
 * 
 * class to hold process specific layout data for each activity
 * the data will be write out to a javascript map 
 * so that activity layout in the published site can get the status dynamically.
 *
 * @author Jinhua Xi
 * @since 1.0
 */
public class ProcessLayoutData {

	Map activityMap = new HashMap();
	public ProcessLayoutData(String proc_guid)
	{
	}
	
	public boolean hasActivityLayout(String activity_path)
	{
		return activityMap.containsKey(activity_path);
	}
	
	public ActivityLayoutData createActivityLauoutData(String activity_path)
	{
		ActivityLayoutData data = (ActivityLayoutData)activityMap.get(activity_path);
		if ( data == null )
		{
			data = new ActivityLayoutData(this, activity_path);
			activityMap.put(activity_path, data);
		}
		
		return data;
	}
	
	public Map getActivityLayoutDataMap()
	{
		return activityMap;
	}
	
	public void print(PrintStream ps)
	{
		for ( Iterator it = activityMap.entrySet().iterator(); it.hasNext(); )
		{
			Map.Entry entry = (Map.Entry)it.next();
			String activity_path = (String)entry.getKey();
			ActivityLayoutData data = (ActivityLayoutData)entry.getValue();
			if ( data.ad_img_path != null )
			{
				String key = activity_path + ResourceHelper.DIAGRAM_TYPE_WORKFLOW;
				printImgFile(ps, key, data.ad_img_path);
			}
			
			if ( data.add_img_path != null )
			{
				String key = activity_path + ResourceHelper.DIAGRAM_TYPE_ACTIVITY_DETAIL;
				printImgFile(ps, key, data.add_img_path);
			}
			
			if ( data.wpd_img_path != null )
			{
				String key = activity_path + ResourceHelper.DIAGRAM_TYPE_WP_DEPENDENCY;
				printImgFile(ps, key, data.wpd_img_path);
			}

			if ( data.getSuppressedItems().size() > 0 )
			{
				for ( Iterator it2 = data.getSuppressedItems().iterator(); it2.hasNext(); )
				{
					String relPath = (String)it2.next();
					String key = activity_path + relPath;
					printSuppressedItem(ps, key);
				}
			}			
		}
	}
	
	private void printImgFile(PrintStream ps, String key, String fileName)
	{
		String line = "imageFiles[\"" + key + "\"]=\"" + fileName + "\"";
		ps.println(line);
		//System.out.println(line);
		
	}
	
	private void printSuppressedItem(PrintStream ps, String key)
	{
		String line = "suppressedItems[\"" + key + "\"]=true";
		ps.println(line);	
		//System.out.println(line);
	}
	
}
