//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.layout.elements;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;


/**
 * The layout for a RoleDescriptor.
 * 
 * @author Jinhua Xi
 * @since 1.0
 */
public class RoleDescriptorLayout extends DescriptorLayout {

	public RoleDescriptorLayout() {
		super();
	}

	public void init(ElementLayoutManager layoutManager, MethodElement element) {
		super.__init(layoutManager, element);
	}

	public XmlElement getXmlElement(boolean includeReferences) {
		XmlElement elementXml = super.getXmlElement(includeReferences);

		// use the default
		// if you need to generate diagram, you may need to keep the feature
		// values.
		// just do something similar to the RoleLayout
		// NOTE: for role-tasks relationship, the feature is
		// RoleDescriptor#getPerformsAsOwner
		// it's a bidirectional feature, don't need opposite feature
		return elementXml;
	}

	public void loadReferences(XmlElement elementXml, boolean includeReferences) {

		super.loadReferences(elementXml, includeReferences);
		
		if ( layoutManager.getValidator().showExtraInfoForDescriptors() ) {
			// also load the linked element referenced information
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Assets(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Checklists(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Examples(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Guidelines(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_SupportingMaterials(), elementXml, false);
		}
	}

}
