//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.layout.elements;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;

/**
 * The layout for a TaskDescriptor.
 * 
 * @author Jinhua Xi
 * @since 1.0
 */
public class TaskDescriptorLayout extends DescriptorLayout {

	public TaskDescriptorLayout() {
		super();
	}

	public void init(ElementLayoutManager layoutManager, MethodElement element) {
		super.__init(layoutManager, element);
	}

	public XmlElement getXmlElement(boolean includeReferences) {
		return super.getXmlElement(includeReferences);
	}
	
	public void loadReferences(XmlElement elementXml, boolean includeReferences) {
		List properties = element.getInstanceProperties();
		if (properties != null) {
			for (int i = 0; i < properties.size(); i++) {
				EStructuralFeature feature = (EStructuralFeature) properties
						.get(i);
				if (feature == UmaPackage.eINSTANCE
						.getTaskDescriptor_SelectedSteps()) {
					// need to handle the step contents by fixing the links
					processSteps(elementXml, includeReferences);

				} else if (feature == UmaPackage.eINSTANCE
						.getWorkBreakdownElement_LinkToPredecessor()) {
					super.loadWorkOrder(elementXml);
				} else if (feature.getEType() instanceof EClass) {
					loadFeature(feature, elementXml, includeReferences);
				}
			}
		}
		
		if ( layoutManager.getValidator().showExtraInfoForDescriptors() ) {
			// also load the linked element referenced information
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getTask_ToolMentors(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Assets(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Checklists(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Examples(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Guidelines(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_SupportingMaterials(), elementXml, false);
		}
	}

	private void processSteps(XmlElement elementXml, boolean includeReferences) {
		EStructuralFeature feature = UmaPackage.eINSTANCE
				.getTaskDescriptor_SelectedSteps();
		List items = ConfigurationHelper.calc0nFeatureValue(element, feature,
				getLayoutMgr().getElementRealizer());
		XmlElement stepXml = elementXml
				.newChild("referenceList").setAttribute("name", feature.getName()); //$NON-NLS-1$ //$NON-NLS-2$

		if (items != null && items.size() > 0) {
			for (Iterator it = items.iterator(); it.hasNext();) {
				Object e = it.next();
				if (e instanceof MethodElement) {
					MethodElement me = (MethodElement) e;
					e = ConfigurationHelper.getCalculatedElement(me,
							layoutManager.getConfiguration());
					if (e != null) {
						IElementLayout l = layoutManager.getLayout(me, true);
						if (l != null) {
							l.setContentTarget(element);
							stepXml.addChild(l
									.getXmlElement(ConfigurationHelper
											.isDescriptionElement(me) ? true
											: includeReferences));
						}
					}
				}
			}
		}
	}

}
